/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostAndPort;
import com.google.inject.assistedinject.Assisted;
import com.sun.net.httpserver.HttpServer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog.metrics.prometheus.ReplaceableCollectorRegistry;
import org.graylog2.shared.SuppressForbidden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusExporterHTTPServer {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusExporterHTTPServer.class);
    private static final int DEFAULT_HTTP_SERVER_BACKLOG = 3;
    private final HostAndPort bindAddress;
    private final AtomicReference<CollectorRegistry> registryRef = new AtomicReference<CollectorRegistry>(PrometheusExporterHTTPServer.newCollectorRegistry());
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private HTTPServer server;

    @Inject
    public PrometheusExporterHTTPServer(@Assisted HostAndPort bindAddress) {
        this.bindAddress = bindAddress;
    }

    private static CollectorRegistry newCollectorRegistry() {
        return new CollectorRegistry(true);
    }

    public void replaceCollector(Collector collector) {
        CollectorRegistry newRegistry = PrometheusExporterHTTPServer.newCollectorRegistry();
        newRegistry.register(collector);
        DefaultExports.register((CollectorRegistry)newRegistry);
        this.registryRef.set(newRegistry);
    }

    @SuppressForbidden(value="Deliberate usage of HttpServer")
    public void start() {
        try {
            InetSocketAddress addr = new InetSocketAddress(this.bindAddress.getHost(), this.bindAddress.getPort());
            HttpServer httpServer = HttpServer.create(addr, 3);
            ReplaceableCollectorRegistry replaceableRegistry = new ReplaceableCollectorRegistry(this.registryRef);
            this.server = new HTTPServer(httpServer, (CollectorRegistry)replaceableRegistry, true);
            this.isRunning.set(true);
            LOG.info("Exporting Prometheus metrics on <{}> via HTTP", (Object)this.bindAddress);
        }
        catch (IOException e) {
            LOG.error("Couldn't start Prometheus HTTP exporter", (Throwable)e);
        }
    }

    public void stop() {
        if (this.server != null) {
            this.isRunning.set(false);
            this.server.stop();
        }
    }

    @VisibleForTesting
    Optional<Integer> getPort() {
        return Optional.ofNullable(this.server).map(HTTPServer::getPort);
    }

    public static interface Factory {
        public PrometheusExporterHTTPServer create(HostAndPort var1);
    }
}

