/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.codecs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import jakarta.inject.Inject;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.netflow.codecs.NetflowV9CodecAggregator;
import org.graylog.plugins.netflow.flows.FlowException;
import org.graylog.plugins.netflow.flows.NetFlowFormatter;
import org.graylog.plugins.netflow.v5.NetFlowV5Packet;
import org.graylog.plugins.netflow.v5.NetFlowV5Parser;
import org.graylog.plugins.netflow.v5.NetFlowV5Record;
import org.graylog.plugins.netflow.v9.NetFlowV9BaseRecord;
import org.graylog.plugins.netflow.v9.NetFlowV9FieldTypeRegistry;
import org.graylog.plugins.netflow.v9.NetFlowV9Journal;
import org.graylog.plugins.netflow.v9.NetFlowV9OptionTemplate;
import org.graylog.plugins.netflow.v9.NetFlowV9Packet;
import org.graylog.plugins.netflow.v9.NetFlowV9Parser;
import org.graylog.plugins.netflow.v9.NetFlowV9Record;
import org.graylog.plugins.netflow.v9.NetFlowV9Template;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.inputs.codecs.MultiMessageCodec;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="netflow", displayName="NetFlow")
public class NetFlowCodec
extends AbstractCodec
implements MultiMessageCodec {
    public static final byte PASSTHROUGH_MARKER = 0;
    public static final byte ORDERED_V9_MARKER = 1;
    @VisibleForTesting
    static final String CK_NETFLOW9_DEFINITION_PATH = "netflow9_definitions_Path";
    private static final Logger LOG = LoggerFactory.getLogger(NetFlowCodec.class);
    private final NetFlowV9FieldTypeRegistry typeRegistry;
    private final NetflowV9CodecAggregator netflowV9CodecAggregator;
    private final NetFlowFormatter netFlowFormatter;

    @Inject
    protected NetFlowCodec(@Assisted Configuration configuration, NetflowV9CodecAggregator netflowV9CodecAggregator, NetFlowFormatter netFlowFormatter) throws IOException {
        super(configuration);
        this.netflowV9CodecAggregator = netflowV9CodecAggregator;
        this.netFlowFormatter = netFlowFormatter;
        String netFlow9DefinitionsPath = configuration.getString(CK_NETFLOW9_DEFINITION_PATH);
        if (netFlow9DefinitionsPath == null || netFlow9DefinitionsPath.trim().isEmpty()) {
            this.typeRegistry = NetFlowV9FieldTypeRegistry.create();
        } else {
            try (FileInputStream inputStream = new FileInputStream(netFlow9DefinitionsPath);){
                this.typeRegistry = NetFlowV9FieldTypeRegistry.create(inputStream);
            }
        }
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return this.netflowV9CodecAggregator;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        throw new UnsupportedOperationException("MultiMessageCodec " + String.valueOf(this.getClass()) + " does not support decode()");
    }

    @Override
    @Nullable
    public Collection<Message> decodeMessages(@Nonnull RawMessage rawMessage) {
        try {
            ResolvableInetSocketAddress remoteAddress = rawMessage.getRemoteAddress();
            InetSocketAddress sender = remoteAddress != null ? remoteAddress.getInetSocketAddress() : null;
            byte[] payload = rawMessage.getPayload();
            if (payload.length < 3) {
                LOG.debug("NetFlow message (source: {}) doesn't even fit the NetFlow version (size: {} bytes)", (Object)sender, (Object)payload.length);
                return null;
            }
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])payload);
            switch (buffer.readByte()) {
                case 0: {
                    NetFlowV5Packet netFlowV5Packet = NetFlowV5Parser.parsePacket(buffer);
                    return netFlowV5Packet.records().stream().map(record -> this.netFlowFormatter.toMessage(netFlowV5Packet.header(), (NetFlowV5Record)record, sender)).collect(Collectors.toList());
                }
                case 1: {
                    return this.decodeV9(sender, buffer);
                }
            }
            List<RawMessage.SourceNode> sourceNodes = rawMessage.getSourceNodes();
            RawMessage.SourceNode sourceNode = sourceNodes.isEmpty() ? null : sourceNodes.get(sourceNodes.size() - 1);
            String inputId = sourceNode == null ? "<unknown>" : sourceNode.inputId;
            LOG.warn("Unsupported NetFlow packet on input {} (source: {})", (Object)inputId, (Object)sender);
            return null;
        }
        catch (FlowException e) {
            LOG.error("Error parsing NetFlow packet <{}> received from <{}>", new Object[]{rawMessage.getId(), rawMessage.getRemoteAddress(), e});
            if (LOG.isDebugEnabled()) {
                LOG.debug("NetFlow packet hexdump:\n{}", (Object)ByteBufUtil.prettyHexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])rawMessage.getPayload())));
            }
            return null;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Invalid NetFlowV9 entry found, cannot parse the messages", ExceptionUtils.getRootCause(e));
            return null;
        }
    }

    @VisibleForTesting
    Collection<Message> decodeV9(InetSocketAddress sender, ByteBuf buffer) throws InvalidProtocolBufferException {
        List<NetFlowV9Packet> netFlowV9Packets = this.decodeV9Packets(buffer);
        return netFlowV9Packets.stream().map(netFlowV9Packet -> netFlowV9Packet.records().stream().filter(record -> record instanceof NetFlowV9Record).map(record -> this.netFlowFormatter.toMessage(netFlowV9Packet.header(), (NetFlowV9BaseRecord)record, sender)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @VisibleForTesting
    List<NetFlowV9Packet> decodeV9Packets(ByteBuf buffer) throws InvalidProtocolBufferException {
        byte[] v9JournalEntry = new byte[buffer.readableBytes()];
        buffer.readBytes(v9JournalEntry);
        NetFlowV9Journal.RawNetflowV9 rawNetflowV9 = NetFlowV9Journal.RawNetflowV9.parseFrom(v9JournalEntry);
        HashMap templateMap = Maps.newHashMap();
        rawNetflowV9.getTemplatesMap().forEach((templateId, byteString) -> {
            NetFlowV9Template netFlowV9Template = NetFlowV9Parser.parseTemplate(Unpooled.wrappedBuffer((byte[])byteString.toByteArray()), this.typeRegistry);
            templateMap.put(templateId, netFlowV9Template);
        });
        NetFlowV9OptionTemplate[] optionTemplate = new NetFlowV9OptionTemplate[]{null};
        rawNetflowV9.getOptionTemplateMap().forEach((templateId, byteString) -> {
            optionTemplate[0] = NetFlowV9Parser.parseOptionTemplate(Unpooled.wrappedBuffer((byte[])byteString.toByteArray()), this.typeRegistry);
        });
        return rawNetflowV9.getPacketsList().stream().map(bytes -> Unpooled.wrappedBuffer((byte[])bytes.toByteArray())).map(buf -> NetFlowV9Parser.parsePacket(buf, this.typeRegistry, templateMap, optionTemplate[0])).collect(Collectors.toList());
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
            if (cr.containsField("port")) {
                cr.getField("port").setDefaultValue(2055);
            }
        }

        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configuration = super.getRequestedConfiguration();
            configuration.addField(new TextField(NetFlowCodec.CK_NETFLOW9_DEFINITION_PATH, "Netflow 9 field definitions", "", "Path to the YAML file containing Netflow 9 field definitions", ConfigurationField.Optional.OPTIONAL));
            return configuration;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<NetFlowCodec> {
        @Override
        public NetFlowCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

