/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.shared.inputs.InputRegistry;

public class FromInput
extends AbstractFunction<Boolean> {
    public static final String NAME = "from_input";
    public static final String ID_ARG = "id";
    public static final String NAME_ARG = "name";
    private final InputRegistry inputRegistry;
    private final ParameterDescriptor<String, String> idParam;
    private final ParameterDescriptor<String, String> nameParam;

    @Inject
    public FromInput(InputRegistry inputRegistry) {
        this.inputRegistry = inputRegistry;
        this.idParam = ParameterDescriptor.string(ID_ARG).optional().description("The input's ID, this is much faster than 'name'").build();
        this.nameParam = ParameterDescriptor.string(NAME_ARG).optional().description("The input's name").build();
    }

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        String id = this.idParam.optional(args, context).orElse("");
        MessageInput input = null;
        if ("".equals(id)) {
            String name = this.nameParam.optional(args, context).orElse("");
            for (IOState<MessageInput> messageInputIOState : this.inputRegistry.getInputStates()) {
                MessageInput messageInput = messageInputIOState.getStoppable();
                if (!messageInput.getTitle().equalsIgnoreCase(name)) continue;
                input = messageInput;
                break;
            }
            if ("".equals(name)) {
                return null;
            }
        } else {
            IOState<MessageInput> inputState = this.inputRegistry.getInputState(id);
            if (inputState != null) {
                input = inputState.getStoppable();
            }
        }
        return input != null && input.getId().equals(context.currentMessage().getSourceInputId());
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.idParam, this.nameParam)).description("Checks if a message arrived on a given input").ruleBuilderEnabled().ruleBuilderName("Check source input").ruleBuilderTitle("Check if message arrived on input<#if name??> '${name}'</#if><#if id??> '${id}'</#if>").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.BOOLEAN).build();
    }
}

