/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.encoding;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import org.graylog.plugins.pipelineprocessor.functions.encoding.BaseEncodingSingleArgStringFunction;

public class Base16Encode
extends BaseEncodingSingleArgStringFunction {
    public static final String NAME = "base16_encode";
    private static final String ENCODING_NAME = "base16";

    @Override
    protected String getEncodedValue(String value, boolean omitPadding) {
        BaseEncoding encoding = BaseEncoding.base16();
        encoding = omitPadding ? encoding.omitPadding() : encoding;
        return encoding.encode(value.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected String getEncodingName() {
        return ENCODING_NAME;
    }

    @Override
    protected String getRuleBuilderName() {
        return "Encode base16";
    }

    @Override
    protected String getRuleBuilderTitle() {
        return "base16 encoding of '${value}'";
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

