/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ObjectUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.shared.utilities.StringUtils;

public class CloneMessage
extends AbstractFunction<Message> {
    private static final RateLimitedLog LOG = PipelineInterpreter.getRateLimitedLog(CloneMessage.class);
    public static final String NAME = "clone_message";
    private static final String CLONE_SOURCE = "gl2_clone_source_rule";
    private static final String CLONE_NUMBER = "gl2_clone_number";
    static final int MAX_CLONES = 100;
    private final ParameterDescriptor<Message, Message> messageParam;
    private final ParameterDescriptor<Boolean, Boolean> loopDetectionParam;
    private final MessageFactory messageFactory;

    @Inject
    public CloneMessage(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
        this.loopDetectionParam = ParameterDescriptor.bool("preventLoops").optional().description("Detects if a cloned message is processed by the same rule again, in order to prevent loops. Defaults to 'false', but will not allow more than 100 clones if not explicitly set.").build();
        this.messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to use, defaults to '$message'").build();
    }

    @Override
    public Message evaluate(FunctionArgs args, EvaluationContext context) {
        Rule rule;
        Message currentMessage = this.messageParam.optional(args, context).orElse(context.currentMessage());
        Optional<Boolean> preventLoops = this.loopDetectionParam.optional(args, context);
        int cloneNumber = (Integer)currentMessage.getMetadataValue(CLONE_NUMBER, 0);
        Rule cloneSource = (Rule)currentMessage.getMetadataValue(CLONE_SOURCE);
        if (ObjectUtils.allNotNull((Object[])new Object[]{cloneSource, rule = context.getRule()}) && Objects.equals(cloneSource, rule)) {
            if (preventLoops.orElse(false).booleanValue()) {
                return null;
            }
            if (preventLoops.isEmpty() && cloneNumber >= 100) {
                throw new IllegalStateException(StringUtils.f("Message was cloned more than %d times by rule '%s'. Not allowing any more clones to prevent a potential endless loop. If this was intentional, please explicitly set the 'preventLoops' parameter to 'false'.", 100, cloneSource.name()));
            }
        }
        Message clonedMessage = this.messageFactory.createMessage(currentMessage.getMessage(), currentMessage.getSource(), currentMessage.getTimestamp());
        clonedMessage.addFields(currentMessage.getFields());
        clonedMessage.addStreams(currentMessage.getStreams());
        if (rule != null) {
            clonedMessage.setMetadata(CLONE_SOURCE, rule);
        }
        clonedMessage.setMetadata(CLONE_NUMBER, ++cloneNumber);
        context.addCreatedMessage(clonedMessage);
        return clonedMessage;
    }

    @Override
    public FunctionDescriptor<Message> descriptor() {
        return FunctionDescriptor.builder().name(NAME).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.messageParam, this.loopDetectionParam)).returnType(Message.class).description("Clones a message. If no specific message is provided, it clones the currently processed message").ruleBuilderEnabled().ruleBuilderName("Clone message").ruleBuilderTitle("Clone message").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.MESSAGE).build();
    }
}

