/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.rulebuilder.AutoValue_RuleBuilderStep;
import org.mongojack.ObjectId;

@AutoValue
public abstract class RuleBuilderStep {
    public static final String FIELD_ID = "id";
    public static final String FIELD_FUNCTION = "function";
    public static final String FIELD_PARAMETERS = "params";
    public static final String FIELD_OUTPUT = "outputvariable";
    public static final String FIELD_NEGATE = "negate";
    public static final String FIELD_TITLE = "step_title";
    public static final String FIELD_OPERATOR = "operator";
    public static final String FIELD_NESTED_CONDITIONS = "conditions";
    private static final String OUTPUT_PREFIX = "output_";
    private static final Pattern OUTPUT_PATTERN = Pattern.compile("output_(\\d+)");
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$output_(\\d+)");

    @JsonProperty(value="id")
    @Nullable
    @ObjectId
    public abstract String id();

    @JsonProperty(value="function")
    @Nullable
    public abstract String function();

    @JsonProperty(value="params")
    @Nullable
    public abstract Map<String, Object> parameters();

    @JsonProperty(value="outputvariable")
    @Nullable
    public abstract String outputvariable();

    @JsonProperty(value="negate")
    public abstract boolean negate();

    @JsonProperty(value="step_title")
    @Nullable
    public abstract String title();

    @JsonProperty(value="operator")
    @Nullable
    public abstract Operator operator();

    @JsonProperty(value="conditions")
    @Nullable
    public abstract List<RuleBuilderStep> conditions();

    @JsonProperty(value="errors")
    @Nullable
    public abstract List<String> errors();

    @JsonCreator
    public static RuleBuilderStep create(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="function") @Nullable String function, @JsonProperty(value="params") @Nullable Map<String, Object> parameters, @JsonProperty(value="outputvariable") @Nullable String outputvariable, @JsonProperty(value="negate") @Nullable boolean negate, @JsonProperty(value="step_title") @Nullable String title, @JsonProperty(value="operator") @Nullable Operator operator, @JsonProperty(value="conditions") @Nullable List<RuleBuilderStep> conditions, @JsonProperty(value="errors") @Nullable List<String> errors) {
        return RuleBuilderStep.builder().id(id).function(function).parameters(parameters).outputvariable(outputvariable).negate(negate).title(title).operator(operator).conditions(conditions).errors(errors).build();
    }

    public static Builder builder() {
        return new AutoValue_RuleBuilderStep.Builder().negate(false);
    }

    public abstract Builder toBuilder();

    @JsonIgnore
    public int generatedOutputIndex() {
        return this.matchPatternWithIndex(this.outputvariable(), OUTPUT_PATTERN);
    }

    @JsonIgnore
    public int generatedParameterIndex(String parameter) {
        return this.matchPatternWithIndex(parameter, PARAMETER_PATTERN);
    }

    @JsonIgnore
    private int matchPatternWithIndex(String value, Pattern pattern) {
        if (value == null) {
            return -1;
        }
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    @JsonIgnore
    public String generateOutput(int index) {
        return OUTPUT_PREFIX + index;
    }

    @JsonIgnore
    public String generateParam(int index) {
        return "$output_" + index;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder function(String var1);

        public abstract Builder parameters(Map<String, Object> var1);

        public abstract Builder outputvariable(String var1);

        public abstract Builder negate(boolean var1);

        public Builder negate() {
            return this.negate(true);
        }

        public abstract Builder title(String var1);

        public abstract Builder operator(Operator var1);

        public abstract Builder conditions(List<RuleBuilderStep> var1);

        public abstract Builder errors(List<String> var1);

        public abstract RuleBuilderStep build();
    }

    public static enum Operator {
        AND,
        OR;

    }
}

