/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.db.migrations;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragmentService;
import org.graylog2.migrations.Migration;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230613154400_AddImplicitToStringFragments
extends Migration {
    private static final Logger log = LoggerFactory.getLogger(V20230613154400_AddImplicitToStringFragments.class);
    private final RuleFragmentService ruleFragmentService;

    @Inject
    public V20230613154400_AddImplicitToStringFragments(RuleFragmentService ruleFragmentService) {
        this.ruleFragmentService = ruleFragmentService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-06-13T15:44:00Z");
    }

    @Override
    public void upgrade() {
        log.debug("Adding implicit to_string fragments via migration");
        this.ruleFragmentService.upsert(V20230613154400_AddImplicitToStringFragments.createSubstringFragment());
        this.ruleFragmentService.upsert(V20230613154400_AddImplicitToStringFragments.createDateFragment());
        log.debug("implicit to_string fragments were successfully added");
    }

    private static RuleFragment createSubstringFragment() {
        return RuleFragment.builder().fragment("let gl2_fragment_substring_results = substring(\n    value: to_string(${value}),\n    start: ${start}<#if end??>,\n    indexEnd: ${end}</#if>\n  );").descriptor(FunctionDescriptor.builder().name("get_substring").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(ParameterDescriptor.object("value").ruleBuilderVariable().description("The string to extract from").ruleBuilderVariable().build(), ParameterDescriptor.integer("start").allowNegatives(true).description("The position to start from, negative means count back from the end of the String by this many characters").build(), ParameterDescriptor.integer("end").optional().allowNegatives(true).description("The position to end at (exclusive), negative means count back from the end of the String by this many characters, defaults to length of the input string").build())).returnType(String.class).description("Get substring of value").ruleBuilderEnabled(false).ruleBuilderName("Substring").ruleBuilderTitle("Get substring from '${start}' to '${end!\"end\"}' of value").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.STRING).build()).fragmentOutputVariable("gl2_fragment_substring_results").build();
    }

    private static RuleFragment createDateFragment() {
        return RuleFragment.builder().fragment("let gl2_fragment_date_results = parse_date(\n  value: to_string(${value}),\n  pattern: ${pattern}<#if locale??>,\n  locale: ${locale}</#if><#if timezone??>,\n  timezone: ${timezone}</#if>\n);").descriptor(FunctionDescriptor.builder().name("get_date").params((ImmutableList<ParameterDescriptor>)ImmutableList.of(ParameterDescriptor.object("value").ruleBuilderVariable().description("Date string to parse").build(), ParameterDescriptor.string("pattern").description("The pattern to parse the date with, see http://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html").build(), ParameterDescriptor.string("locale").optional().description("The locale to parse the date with, see https://docs.oracle.com/javase/8/docs/api/java/util/Locale.html").build(), ParameterDescriptor.string("timezone").optional().description("The timezone to apply to the date, defaults to UTC").build())).returnType(DateTime.class).description("Parses a value using the given date format").ruleBuilderEnabled(false).ruleBuilderName("Parse date").ruleBuilderTitle("Parse date from value").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.DATE).build()).fragmentOutputVariable("gl2_fragment_date_results").build();
    }
}

