/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.mongodb.client.model.Filters;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.threatintel.ThreatIntelPluginConfiguration;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.database.MongoEntity;
import org.graylog2.database.PaginatedList;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.lookup.events.DataAdaptersUpdated;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.rest.models.SortOrder;
import org.graylog2.shared.utilities.AutoValueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PluginConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(PluginConfigService.class);
    private final ClusterConfigService clusterConfigService;
    private final DBDataAdapterService dbDataAdapterService;
    private final ClusterEventBus clusterEventBus;
    private AtomicReference<ConfigVersions<ThreatIntelPluginConfiguration>> config = new AtomicReference();

    @Inject
    public PluginConfigService(ClusterConfigService clusterConfigService, EventBus serverEventBus, DBDataAdapterService dbDataAdapterService, ClusterEventBus clusterEventBus) {
        this.clusterConfigService = clusterConfigService;
        this.dbDataAdapterService = dbDataAdapterService;
        this.clusterEventBus = clusterEventBus;
        ThreatIntelPluginConfiguration currentVersion = clusterConfigService.get(ThreatIntelPluginConfiguration.class);
        ConfigVersions<ThreatIntelPluginConfiguration> versions = ConfigVersions.of(null, Optional.ofNullable(currentVersion).orElse(ThreatIntelPluginConfiguration.defaults()));
        this.config.set(versions);
        serverEventBus.register((Object)this);
    }

    public ConfigVersions<ThreatIntelPluginConfiguration> config() {
        return this.config.get();
    }

    @Subscribe
    public void handleUpdatedClusterConfig(ClusterConfigChangedEvent clusterConfigChangedEvent) {
        if (clusterConfigChangedEvent.type().equals(AutoValueUtils.getCanonicalName(ThreatIntelPluginConfiguration.class))) {
            ThreatIntelPluginConfiguration currentVersion = Optional.ofNullable(this.clusterConfigService.get(ThreatIntelPluginConfiguration.class)).orElse(ThreatIntelPluginConfiguration.defaults());
            ThreatIntelPluginConfiguration previous = this.config.get().getCurrent();
            this.config.set(ConfigVersions.of(previous, currentVersion));
            ImmutableList.Builder adaptersToLoad = ImmutableList.builder();
            if (previous.abusechRansomEnabled() != currentVersion.abusechRansomEnabled()) {
                adaptersToLoad.add(new Object[]{"abuse-ch-ransomware-domains", "abuse-ch-ransomware-ip"});
            }
            if (previous.torEnabled() != currentVersion.torEnabled()) {
                adaptersToLoad.add((Object)"tor-exit-node");
            }
            if (previous.spamhausEnabled() != currentVersion.spamhausEnabled()) {
                adaptersToLoad.add((Object)"spamhaus-drop");
            }
            ImmutableList adapterNames = adaptersToLoad.build();
            PaginatedList<DataAdapterDto> adapterDtos = this.dbDataAdapterService.findPaginated(Filters.eq((String)"name", (Object)adapterNames), SortOrder.ASCENDING.toBsonSort("id"), 1, 10);
            Set<String> adapterIds = adapterDtos.delegate().stream().map(MongoEntity::id).collect(Collectors.toSet());
            if (!adapterIds.isEmpty()) {
                LOG.debug("Restarting data adapters {} due to updated enabled/disabled states", (Object)adapterNames);
                this.clusterEventBus.post(DataAdaptersUpdated.create(adapterIds));
            }
        }
    }

    public static class ConfigVersions<T> {
        @Nullable
        private final T previous;
        @Nonnull
        private final T current;

        public ConfigVersions(@Nullable T previous, @Nonnull T current) {
            this.previous = previous;
            this.current = current;
        }

        public static <T> ConfigVersions<T> of(@Nullable T previous, @Nonnull T current) {
            return new ConfigVersions<T>(previous, current);
        }

        public Optional<T> getPrevious() {
            return Optional.ofNullable(this.previous);
        }

        @Nonnull
        public T getCurrent() {
            return this.current;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigVersions that = (ConfigVersions)o;
            return Objects.equals(this.previous, that.previous) && Objects.equals(this.current, that.current);
        }

        public int hashCode() {
            return Objects.hash(this.previous, this.current);
        }
    }
}

