/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.auto.value.AutoValue;
import java.util.Locale;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.BucketInterval;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AutoValue_TimeUnitInterval;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.Interval;

@AutoValue
public abstract class TimeUnitInterval
implements Interval {
    public static final String type = "timeunit";
    static final String FIELD_TYPE = "type";
    static final String FIELD_VALUE = "value";
    static final String FIELD_UNIT = "unit";

    @Override
    @JsonProperty
    public abstract String type();

    @JsonProperty(value="value")
    public abstract int value();

    @JsonProperty(value="unit")
    public abstract IntervalUnit unit();

    @Override
    public BucketInterval toBucketInterval() {
        String esUnit = this.mapUnit(this.unit());
        return org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.TimeUnitInterval.create(this.value() + esUnit);
    }

    private String mapUnit(IntervalUnit unit) {
        switch (unit) {
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
            case WEEKS: {
                return "w";
            }
            case MONTHS: {
                return "M";
            }
            case YEARS: {
                return "y";
            }
        }
        throw new RuntimeException("Unable to map interval unit: " + String.valueOf((Object)unit));
    }

    private static Builder builder() {
        return new AutoValue_TimeUnitInterval.Builder().type(type);
    }

    public static TimeUnitInterval create(IntervalUnit unit, int value) {
        return TimeUnitInterval.builder().unit(unit).value(value).build();
    }

    public static enum IntervalUnit {
        SECONDS("seconds"),
        MINUTES("minutes"),
        HOURS("hours"),
        DAYS("days"),
        WEEKS("weeks"),
        MONTHS("months"),
        YEARS("years"),
        AUTO("auto");

        private final String name;

        private IntervalUnit(String name) {
            this.name = name;
        }

        @JsonValue
        public String toString() {
            return this.name;
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder type(String var1);

        public abstract Builder value(int var1);

        public abstract Builder unit(IntervalUnit var1);

        public Builder unit(String unit) {
            return this.unit(IntervalUnit.valueOf(unit.toUpperCase(Locale.ENGLISH)));
        }

        public abstract TimeUnitInterval build();
    }
}

