/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.Query;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.SearchType;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.search.StreamFilter;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.ElasticsearchQueryString;
import org.graylog.plugins.views.migrations.V20191203120602_MigrateSavedSearchesToViewsSupport.view.TimeRange;

final class AutoValue_Query
extends Query {
    private final String id;
    private final TimeRange timerange;
    private final Optional<StreamFilter> filter;
    private final ElasticsearchQueryString query;
    private final Set<SearchType> searchTypes;

    private AutoValue_Query(String id, TimeRange timerange, Optional<StreamFilter> filter, ElasticsearchQueryString query, Set<SearchType> searchTypes) {
        this.id = id;
        this.timerange = timerange;
        this.filter = filter;
        this.query = query;
        this.searchTypes = searchTypes;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty
    public Optional<StreamFilter> filter() {
        return this.filter;
    }

    @Override
    @JsonProperty
    @Nonnull
    public ElasticsearchQueryString query() {
        return this.query;
    }

    @Override
    @JsonProperty(value="search_types")
    @Nonnull
    public Set<SearchType> searchTypes() {
        return this.searchTypes;
    }

    public String toString() {
        return "Query{id=" + this.id + ", timerange=" + String.valueOf(this.timerange) + ", filter=" + String.valueOf(this.filter) + ", query=" + String.valueOf(this.query) + ", searchTypes=" + String.valueOf(this.searchTypes) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Query) {
            Query that = (Query)o;
            return this.id.equals(that.id()) && this.timerange.equals(that.timerange()) && this.filter.equals(that.filter()) && this.query.equals(that.query()) && this.searchTypes.equals(that.searchTypes());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        return h$ ^= this.searchTypes.hashCode();
    }

    static final class Builder
    extends Query.Builder {
        private String id;
        private TimeRange timerange;
        private Optional<StreamFilter> filter = Optional.empty();
        private ElasticsearchQueryString query;
        private Set<SearchType> searchTypes;

        Builder() {
        }

        @Override
        public Query.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public Query.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public Query.Builder filter(StreamFilter filter) {
            this.filter = Optional.of(filter);
            return this;
        }

        @Override
        Query.Builder query(ElasticsearchQueryString query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public Query.Builder searchTypes(Set<SearchType> searchTypes) {
            if (searchTypes == null) {
                throw new NullPointerException("Null searchTypes");
            }
            this.searchTypes = searchTypes;
            return this;
        }

        @Override
        public Query build() {
            if (this.id == null || this.timerange == null || this.query == null || this.searchTypes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.id == null) {
                    missing.append(" id");
                }
                if (this.timerange == null) {
                    missing.append(" timerange");
                }
                if (this.query == null) {
                    missing.append(" query");
                }
                if (this.searchTypes == null) {
                    missing.append(" searchTypes");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_Query(this.id, this.timerange, this.filter, this.query, this.searchTypes);
        }
    }
}

