/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.ExplainResults;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryMetadata;
import org.graylog.plugins.views.search.QueryMetadataDecorator;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.engine.QueryParser;
import org.graylog.plugins.views.search.errors.QueryError;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchException;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QueryEngine {
    private static final Logger LOG = LoggerFactory.getLogger(QueryEngine.class);
    private final Set<QueryMetadataDecorator> queryMetadataDecorators;
    private final QueryParser queryParser;
    private final Executor queryPool = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("query-engine-%d").build());
    private final QueryBackend<? extends GeneratedQueryContext> backend;

    @Inject
    public QueryEngine(QueryBackend<? extends GeneratedQueryContext> backend, Set<QueryMetadataDecorator> queryMetadataDecorators, QueryParser queryParser) {
        this.backend = backend;
        this.queryMetadataDecorators = queryMetadataDecorators;
        this.queryParser = queryParser;
    }

    public QueryMetadata parse(Search search, Query query) {
        QueryMetadata parsedMetadata = this.queryParser.parse(query);
        return this.queryMetadataDecorators.stream().reduce((decorator1, decorator2) -> (s, q, metadata) -> decorator1.decorate(s, q, decorator2.decorate(s, q, metadata))).map(decorator -> decorator.decorate(search, query, parsedMetadata)).orElse(parsedMetadata);
    }

    public ExplainResults explain(SearchJob searchJob, Set<SearchError> validationErrors, DateTimeZone timezone) {
        Map<String, ExplainResults.QueryExplainResult> queries = searchJob.getSearch().queries().stream().collect(Collectors.toMap(Query::id, q -> {
            GeneratedQueryContext generatedQueryContext = this.backend.generate((Query)q, Set.of(), timezone);
            return this.backend.explain(searchJob, (Query)q, generatedQueryContext);
        }));
        return new ExplainResults(searchJob.getSearchId(), new ExplainResults.SearchResult(queries), validationErrors);
    }

    @WithSpan
    public SearchJob execute(SearchJob searchJob, Set<SearchError> validationErrors, DateTimeZone timezone) {
        Set<Query> validQueries = searchJob.getSearch().queries().stream().filter(query -> !this.isQueryWithError((Collection<SearchError>)validationErrors, (Query)query)).collect(Collectors.toSet());
        validQueries.forEach(query -> searchJob.addQueryResultFuture(query.id(), (CompletableFuture<QueryResult>)CompletableFuture.supplyAsync(() -> this.prepareAndRun(searchJob, (Query)query, validationErrors, timezone), this.queryPool).handle((queryResult, throwable) -> {
            if (throwable != null) {
                Throwable cause = throwable.getCause();
                SearchError error = cause instanceof SearchException ? ((SearchException)cause).error() : new QueryError((Query)query, cause);
                LOG.debug("Running query {} failed: {}", (Object)query.id(), (Object)cause);
                searchJob.addError(error);
                return QueryResult.failedQueryWithError(query, error);
            }
            return queryResult;
        })));
        LOG.debug("Search job {} executing", (Object)searchJob.getId());
        return searchJob.seal();
    }

    private QueryResult prepareAndRun(SearchJob searchJob, Query query, Set<SearchError> validationErrors, DateTimeZone timezone) {
        LOG.debug("[{}] Using {} to generate query", (Object)query.id(), this.backend);
        GeneratedQueryContext generatedQueryContext = this.backend.generate(query, validationErrors, timezone);
        LOG.trace("[{}] Generated query {}, running it on backend {}", new Object[]{query.id(), generatedQueryContext, this.backend});
        QueryResult result = this.backend.run(searchJob, query, generatedQueryContext);
        LOG.debug("[{}] Query returned {}", (Object)query.id(), (Object)result);
        if (!generatedQueryContext.errors().isEmpty()) {
            generatedQueryContext.errors().forEach(searchJob::addError);
        }
        return result;
    }

    private boolean isQueryWithError(Collection<SearchError> validationErrors, Query query) {
        return validationErrors.stream().filter(q -> q instanceof QueryError).map(q -> (QueryError)q).map(QueryError::queryId).anyMatch(id -> Objects.equals(id, query.id()));
    }
}

