/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.permissions;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.permissions.StreamPermissions;
import org.graylog.plugins.views.search.rest.FieldTypesResource;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog2.shared.rest.exceptions.MissingStreamPermissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStreams {
    private final StreamPermissions streamPermissions;
    private final PermittedStreams permittedStreams;
    private static final Logger LOG = LoggerFactory.getLogger(FieldTypesResource.class);

    public UserStreams(StreamPermissions streamPermissions, PermittedStreams permittedStreams) {
        this.streamPermissions = streamPermissions;
        this.permittedStreams = permittedStreams;
    }

    public ImmutableSet<String> loadAllMessageStreams() {
        return this.permittedStreams.loadAllMessageStreams(this.streamPermissions);
    }

    public ImmutableSet<String> loadAllStreams() {
        return this.permittedStreams.loadAll(this.streamPermissions);
    }

    public ImmutableSet<String> loadMessageStreamsWithFallback() {
        ImmutableSet<String> messageStreams = this.loadAllMessageStreams();
        if (!messageStreams.isEmpty()) {
            return messageStreams;
        }
        return this.loadAllStreams();
    }

    public ImmutableSet<String> loadStreamsWithCategories(Set<String> categories) {
        return this.permittedStreams.loadWithCategories(categories, this.streamPermissions);
    }

    public ImmutableSet<String> readableOrAllIfEmpty(@Nullable Set<String> requestedStreams) {
        if (requestedStreams == null || requestedStreams.isEmpty()) {
            return this.loadMessageStreamsWithFallback();
        }
        Set<String> notPermittedStreams = requestedStreams.stream().filter(s -> !this.streamPermissions.canReadStream((String)s)).collect(Collectors.toSet());
        if (!notPermittedStreams.isEmpty()) {
            LOG.info("Not authorized to access resource id <{}>. User is missing permission <{}:{}>", new Object[]{notPermittedStreams, "streams:read", notPermittedStreams});
            throw new MissingStreamPermissionException("Not authorized to access streams.", notPermittedStreams);
        }
        return ImmutableSet.copyOf(requestedStreams);
    }

    public ImmutableSet<String> readableOrAllIfEmpty(Optional<Set<String>> requestedStreams) {
        return this.readableOrAllIfEmpty((Set<String>)requestedStreams.orElse(null));
    }
}

