/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.rest.AutoValue_ValidationRequestDTO;
import org.graylog.plugins.views.search.rest.ValidationModeDTO;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ValidationRequestDTO {
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_STREAM_CATEGORIES = "stream_categories";
    private static final String FIELD_TIMERANGE = "timerange";

    @JsonProperty
    public abstract BackendQuery query();

    @JsonProperty
    public abstract Optional<BackendQuery> filter();

    @JsonProperty(value="timerange")
    public abstract Optional<TimeRange> timerange();

    @JsonProperty(value="streams")
    public abstract Optional<Set<String>> streams();

    @JsonProperty(value="stream_categories")
    public abstract Optional<Set<String>> streamCategories();

    @JsonProperty
    public abstract ImmutableSet<Parameter> parameters();

    @JsonProperty
    public abstract ImmutableMap<String, Parameter.Binding> parameterBindings();

    @JsonProperty
    public abstract ValidationModeDTO validationMode();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder query(BackendQuery var1);

        @JsonProperty
        public abstract Builder filter(@Nullable BackendQuery var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(@Nullable Set<String> var1);

        @JsonProperty(value="stream_categories")
        public abstract Builder streamCategories(@Nullable Set<String> var1);

        @JsonProperty(value="timerange")
        public abstract Builder timerange(@Nullable TimeRange var1);

        public abstract ImmutableMap.Builder<String, Parameter.Binding> parameterBindingsBuilder();

        @JsonProperty(value="parameter_bindings")
        public Builder withParameterBindings(Map<String, Parameter.Binding> values) {
            values.forEach((s, o) -> this.parameterBindingsBuilder().put(s, o));
            return this;
        }

        public abstract ImmutableSet.Builder<Parameter> parametersBuilder();

        @JsonProperty
        public Builder withParameters(Set<Parameter> values) {
            values.forEach(p -> this.parametersBuilder().add(p));
            return this;
        }

        @JsonProperty
        public abstract Builder validationMode(ValidationModeDTO var1);

        public abstract ValidationRequestDTO build();

        @JsonCreator
        public static Builder builder() {
            return new AutoValue_ValidationRequestDTO.Builder().validationMode(ValidationModeDTO.QUERY);
        }
    }
}

