/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.subject.Subject;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.MappedFieldTypeDTO;
import org.graylog.plugins.views.search.rest.SearchJobDTO;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.MessageFieldTypeMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryFailedException;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.TabularResponseCreator;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MessagesRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.RequestedField;
import org.graylog.plugins.views.search.rest.scriptingapi.response.Metadata;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseSchemaEntry;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.CachingDecorator;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.FieldDecorator;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog2.indexer.fieldtypes.MappedFieldTypesService;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesTabularResponseCreator
implements TabularResponseCreator {
    private static final Logger LOG = LoggerFactory.getLogger(MessagesTabularResponseCreator.class);
    private final MappedFieldTypesService mappedFieldTypesService;
    private final Set<FieldDecorator> decorators;

    @Inject
    public MessagesTabularResponseCreator(MappedFieldTypesService mappedFieldTypesService, Set<FieldDecorator> decorators) {
        this.mappedFieldTypesService = mappedFieldTypesService;
        this.decorators = decorators;
    }

    public TabularResponse mapToResponse(MessagesRequestSpec messagesRequestSpec, SearchJob searchJob, SearchUser searchUser, Subject subject) throws QueryFailedException {
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        QueryResult queryResult = searchJobDTO.results().get("scripting_api_temporary_query");
        if (queryResult != null) {
            this.throwErrorIfAnyAvailable(queryResult);
            SearchType.Result messageListResult = queryResult.searchTypes().get("scripting_api_temporary_message_list");
            if (messageListResult instanceof MessageList.Result) {
                MessageList.Result messagesResult = (MessageList.Result)messageListResult;
                return this.mapToResponse(messagesRequestSpec, messagesResult, searchUser);
            }
        }
        LOG.warn("Scripting API failed to obtain messages for input : " + String.valueOf(messagesRequestSpec));
        throw new QueryFailedException("Scripting API failed to obtain messages for input : " + String.valueOf(messagesRequestSpec));
    }

    private TabularResponse mapToResponse(MessagesRequestSpec searchRequestSpec, MessageList.Result messageListResult, SearchUser searchUser) {
        return new TabularResponse(this.getSchema(searchRequestSpec, searchUser), this.getDatarows(searchRequestSpec, messageListResult, searchUser), new Metadata(messageListResult.effectiveTimerange()));
    }

    private List<ResponseSchemaEntry> getSchema(MessagesRequestSpec searchRequestSpec, SearchUser searchUser) {
        ImmutableSet<String> streams = searchUser.streams().readableOrAllIfEmpty(searchRequestSpec.streams());
        Set<MappedFieldTypeDTO> knownFields = this.mappedFieldTypesService.fieldTypesByStreamIds((Collection<String>)streams, searchRequestSpec.timerange());
        MessageFieldTypeMapper fieldsMapper = new MessageFieldTypeMapper(knownFields);
        return searchRequestSpec.requestedFields().stream().map(fieldsMapper).collect(Collectors.toList());
    }

    private List<List<Object>> getDatarows(MessagesRequestSpec messagesRequestSpec, MessageList.Result messageListResult, SearchUser searchUser) {
        Set cachedDecorators = this.decorators.stream().map(CachingDecorator::new).collect(Collectors.toSet());
        return messageListResult.messages().stream().map(message -> messagesRequestSpec.requestedFields().stream().map(field -> this.extractValue((ResultMessageSummary)message, (RequestedField)field, cachedDecorators, searchUser)).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private Object extractValue(ResultMessageSummary message, RequestedField field, Set<FieldDecorator> decorators, SearchUser searchUser) {
        return Optional.ofNullable(message.message().get(field.name())).map(value -> this.decorate(decorators, field, value, searchUser)).orElse("-");
    }
}

