/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.searchtypes.export;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog.plugins.views.search.util.ListOfStringsComparator;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;

public record ExportTabularResultResponse(@JsonProperty List<String> header, @JsonProperty @JacksonXmlElementWrapper(useWrapping=false) List<DataRow> dataRows) {
    public static ExportTabularResultResponse fromPivotResult(PivotResult pivotResult) {
        ImmutableList<PivotResult.Row> rows = pivotResult.rows();
        int longestRowKey = rows.stream().mapToInt(row -> row.key().size()).max().orElse(0);
        List<List<String>> columns = rows.stream().flatMap(row -> row.values().stream().map(PivotResult.Value::key)).distinct().sorted(new ListOfStringsComparator()).toList();
        ArrayList<String> header = new ArrayList<String>(longestRowKey + columns.size());
        header.addAll(Collections.nCopies(longestRowKey, ""));
        columns.forEach(column -> header.add(column.toString()));
        List<DataRow> dataRows = rows.stream().filter(row -> "leaf".equals(row.source())).map(row -> {
            ImmutableList<String> key = row.key();
            List<Object> values = columns.stream().map(metric -> row.values().stream().filter(value -> value.key().equals(metric)).filter(value -> value.value() != null).findFirst().map(value -> value.value()).orElse(null)).toList();
            ArrayList<Object> dataRow = new ArrayList<Object>();
            dataRow.addAll((Collection<Object>)key);
            dataRow.addAll(values);
            return new DataRow(dataRow);
        }).toList();
        return new ExportTabularResultResponse(header, dataRows);
    }

    public static ExportTabularResultResponse fromMessageListResult(MessageList.Result m) {
        if (m.messages().isEmpty()) {
            return new ExportTabularResultResponse(List.of(), List.of());
        }
        ResultMessageSummary first = m.messages().get(0);
        List<String> header = first.message().keySet().stream().toList();
        List<DataRow> rows = m.messages().stream().map(message -> new DataRow(header.stream().map(key -> message.message().get(key)).toList())).toList();
        return new ExportTabularResultResponse(header, rows);
    }

    public static ExportTabularResultResponse fromDocumentList(List<Document> documents, List<String> exportedFields) {
        return new ExportTabularResultResponse(exportedFields, documents.stream().map(doc -> new DataRow(exportedFields.stream().map(arg_0 -> ((Document)doc).get(arg_0)).toList())).toList());
    }

    public record DataRow(@JacksonXmlElementWrapper(useWrapping=false) List<Object> row) {
    }
}

