/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.scheduler.periodicals;

import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.graylog.scheduler.DBJobTriggerService;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleTriggerCleanUp
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleTriggerCleanUp.class);
    private final DBJobTriggerService dbJobTriggerService;
    private static final long OUTOFDATE_IN_DAYS = 1L;

    @Inject
    public ScheduleTriggerCleanUp(DBJobTriggerService dbJobTriggerService) {
        this.dbJobTriggerService = dbJobTriggerService;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 120;
    }

    @Override
    public int getPeriodSeconds() {
        return 86400;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        int deleted = this.dbJobTriggerService.deleteCompletedOnceSchedulesOlderThan(1L, TimeUnit.DAYS);
        if (deleted > 0) {
            LOG.debug("Deleted {} outdated OnceJobSchedule triggers.", (Object)deleted);
        }
    }
}

