/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.grn.GRN;
import org.graylog.security.AutoValue_GrantDTO;
import org.graylog.security.Capability;
import org.graylog.security.GrantDTO;
import org.mongojack.Id;
import org.mongojack.ObjectId;

abstract class $AutoValue_GrantDTO
extends GrantDTO {
    @Nullable
    private final String id;
    private final GRN grantee;
    @NotNull
    private final Capability capability;
    @NotNull
    private final GRN target;
    private final String createdBy;
    private final ZonedDateTime createdAt;
    private final String updatedBy;
    private final ZonedDateTime updatedAt;
    private final Optional<ZonedDateTime> expiresAt;

    $AutoValue_GrantDTO(@Nullable String id, GRN grantee, @NotNull Capability capability, @NotNull GRN target, String createdBy, ZonedDateTime createdAt, String updatedBy, ZonedDateTime updatedAt, Optional<ZonedDateTime> expiresAt) {
        this.id = id;
        if (grantee == null) {
            throw new NullPointerException("Null grantee");
        }
        this.grantee = grantee;
        if (capability == null) {
            throw new NullPointerException("Null capability");
        }
        this.capability = capability;
        if (target == null) {
            throw new NullPointerException("Null target");
        }
        this.target = target;
        if (createdBy == null) {
            throw new NullPointerException("Null createdBy");
        }
        this.createdBy = createdBy;
        if (createdAt == null) {
            throw new NullPointerException("Null createdAt");
        }
        this.createdAt = createdAt;
        if (updatedBy == null) {
            throw new NullPointerException("Null updatedBy");
        }
        this.updatedBy = updatedBy;
        if (updatedAt == null) {
            throw new NullPointerException("Null updatedAt");
        }
        this.updatedAt = updatedAt;
        if (expiresAt == null) {
            throw new NullPointerException("Null expiresAt");
        }
        this.expiresAt = expiresAt;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="grantee")
    public GRN grantee() {
        return this.grantee;
    }

    @Override
    @JsonProperty(value="capability")
    @NotNull
    public Capability capability() {
        return this.capability;
    }

    @Override
    @JsonProperty(value="target")
    @NotNull
    public GRN target() {
        return this.target;
    }

    @Override
    @JsonProperty(value="created_by")
    public String createdBy() {
        return this.createdBy;
    }

    @Override
    @JsonProperty(value="created_at")
    public ZonedDateTime createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="updated_by")
    public String updatedBy() {
        return this.updatedBy;
    }

    @Override
    @JsonProperty(value="updated_at")
    public ZonedDateTime updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="expires_at")
    public Optional<ZonedDateTime> expiresAt() {
        return this.expiresAt;
    }

    public String toString() {
        return "GrantDTO{id=" + this.id + ", grantee=" + String.valueOf(this.grantee) + ", capability=" + String.valueOf((Object)this.capability) + ", target=" + String.valueOf(this.target) + ", createdBy=" + this.createdBy + ", createdAt=" + String.valueOf(this.createdAt) + ", updatedBy=" + this.updatedBy + ", updatedAt=" + String.valueOf(this.updatedAt) + ", expiresAt=" + String.valueOf(this.expiresAt) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GrantDTO) {
            GrantDTO that = (GrantDTO)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.grantee.equals(that.grantee()) && this.capability.equals((Object)that.capability()) && this.target.equals(that.target()) && this.createdBy.equals(that.createdBy()) && this.createdAt.equals(that.createdAt()) && this.updatedBy.equals(that.updatedBy()) && this.updatedAt.equals(that.updatedAt()) && this.expiresAt.equals(that.expiresAt());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.grantee.hashCode();
        h$ *= 1000003;
        h$ ^= this.capability.hashCode();
        h$ *= 1000003;
        h$ ^= this.target.hashCode();
        h$ *= 1000003;
        h$ ^= this.createdBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.createdAt.hashCode();
        h$ *= 1000003;
        h$ ^= this.updatedBy.hashCode();
        h$ *= 1000003;
        h$ ^= this.updatedAt.hashCode();
        h$ *= 1000003;
        return h$ ^= this.expiresAt.hashCode();
    }

    @Override
    public GrantDTO.Builder toBuilder() {
        return new Builder(this);
    }

    static class Builder
    extends GrantDTO.Builder {
        private String id;
        private GRN grantee;
        @NotNull
        private Capability capability;
        @NotNull
        private GRN target;
        private String createdBy;
        private ZonedDateTime createdAt;
        private String updatedBy;
        private ZonedDateTime updatedAt;
        private Optional<ZonedDateTime> expiresAt = Optional.empty();

        Builder() {
        }

        Builder(GrantDTO source) {
            this.id = source.id();
            this.grantee = source.grantee();
            this.capability = source.capability();
            this.target = source.target();
            this.createdBy = source.createdBy();
            this.createdAt = source.createdAt();
            this.updatedBy = source.updatedBy();
            this.updatedAt = source.updatedAt();
            this.expiresAt = source.expiresAt();
        }

        @Override
        public GrantDTO.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public GrantDTO.Builder grantee(GRN grantee) {
            if (grantee == null) {
                throw new NullPointerException("Null grantee");
            }
            this.grantee = grantee;
            return this;
        }

        @Override
        public GrantDTO.Builder capability(Capability capability) {
            if (capability == null) {
                throw new NullPointerException("Null capability");
            }
            this.capability = capability;
            return this;
        }

        @Override
        public GrantDTO.Builder target(GRN target) {
            if (target == null) {
                throw new NullPointerException("Null target");
            }
            this.target = target;
            return this;
        }

        @Override
        public GrantDTO.Builder createdBy(String createdBy) {
            if (createdBy == null) {
                throw new NullPointerException("Null createdBy");
            }
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public GrantDTO.Builder createdAt(ZonedDateTime createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("Null createdAt");
            }
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public GrantDTO.Builder updatedBy(String updatedBy) {
            if (updatedBy == null) {
                throw new NullPointerException("Null updatedBy");
            }
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public GrantDTO.Builder updatedAt(ZonedDateTime updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("Null updatedAt");
            }
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GrantDTO.Builder expiresAt(@Nullable ZonedDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @Override
        public GrantDTO build() {
            if (this.grantee == null || this.capability == null || this.target == null || this.createdBy == null || this.createdAt == null || this.updatedBy == null || this.updatedAt == null) {
                StringBuilder missing = new StringBuilder();
                if (this.grantee == null) {
                    missing.append(" grantee");
                }
                if (this.capability == null) {
                    missing.append(" capability");
                }
                if (this.target == null) {
                    missing.append(" target");
                }
                if (this.createdBy == null) {
                    missing.append(" createdBy");
                }
                if (this.createdAt == null) {
                    missing.append(" createdAt");
                }
                if (this.updatedBy == null) {
                    missing.append(" updatedBy");
                }
                if (this.updatedAt == null) {
                    missing.append(" updatedAt");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_GrantDTO(this.id, this.grantee, this.capability, this.target, this.createdBy, this.createdAt, this.updatedBy, this.updatedAt, this.expiresAt);
        }
    }
}

