/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Locale;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog2.bootstrap.CliCommand;

@Command(name="truststore", description="Manage certificates for data-node", groupNames={"certutil"})
public class CertutilTruststore
implements CliCommand {
    @Option(name={"--ca"}, description="Filename for the CA keystore")
    protected String caKeystoreFilename = "datanode-ca.p12";
    @Option(name={"--truststore"}, description="Filename for the generated truststore")
    protected String truststoreFilename = "datanode-truststore.p12";
    private final CommandLineConsole console;
    public static final CommandLineConsole.Prompt PROMPT_ENTER_CA_PASSWORD = CommandLineConsole.prompt("Enter CA password: ");
    public static final CommandLineConsole.Prompt PROMPT_ENTER_TRUSTSTORE_PASSWORD = CommandLineConsole.prompt("Enter datanode truststore password: ");

    public CertutilTruststore() {
        this.console = new SystemConsole();
    }

    public CertutilTruststore(String caKeystoreFilename, String truststoreFilename, CommandLineConsole console) {
        this.caKeystoreFilename = caKeystoreFilename;
        this.truststoreFilename = truststoreFilename;
        this.console = console;
    }

    @Override
    public void run() {
        this.console.printLine("This tool will generate a truststore with certificate of provided certificate authority");
        Path caKeystorePath = Path.of(this.caKeystoreFilename, new String[0]);
        this.console.printLine("Using certificate authority " + String.valueOf(caKeystorePath.toAbsolutePath()));
        try {
            char[] password = this.console.readPassword(PROMPT_ENTER_CA_PASSWORD);
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(new FileInputStream(caKeystorePath.toFile()), password);
            X509Certificate caCertificate = (X509Certificate)caKeystore.getCertificate("ca");
            this.console.printLine("Successfully read CA from the keystore");
            this.console.printLine(CertutilTruststore.certificateInfo(caCertificate));
            KeyStore truststore = KeyStore.getInstance("PKCS12");
            truststore.load(null, null);
            char[] truststorePassword = this.console.readPassword(PROMPT_ENTER_TRUSTSTORE_PASSWORD);
            truststore.setCertificateEntry("ca", caCertificate);
            Path nodeKeystorePath = Path.of(this.truststoreFilename, new String[0]);
            try (FileOutputStream store = new FileOutputStream(nodeKeystorePath.toFile());){
                truststore.store(store, truststorePassword);
                this.console.printLine("Truststore with the CA certificate successfully saved into " + String.valueOf(nodeKeystorePath.toAbsolutePath()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String certificateInfo(X509Certificate cert) {
        return String.format(Locale.ROOT, "Subject: %s, issuer: %s, not before: %s, not after: %s", cert.getSubjectX500Principal(), cert.getIssuerX500Principal(), cert.getNotBefore(), cert.getNotAfter());
    }
}

