/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.ca;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.security.certutil.keystore.storage.KeystoreUtils;

public class CA {
    private final List<X509Certificate> certificates;
    private final PrivateKey privateKey;

    public CA(List<X509Certificate> certificates, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.certificates = this.validateAndSortCertificates(certificates);
    }

    private List<X509Certificate> validateAndSortCertificates(List<X509Certificate> certificates) {
        X509Certificate ca;
        if (certificates == null || certificates.isEmpty()) {
            throw new IllegalArgumentException("Certificate list is empty");
        }
        if (certificates.size() > 1 && !this.isCertPathOrderedCorrectly(certificates)) {
            certificates = this.sortCertificates(certificates);
        }
        if ((ca = certificates.get(0)).getBasicConstraints() == -1) {
            throw new IllegalArgumentException("First certificate in certificate chain is no CA. Please make sure that your bundle only contains the CA and necessary intermediate/root certificates");
        }
        try {
            if (!KeystoreUtils.matchingKeys(this.privateKey, ca.getPublicKey())) {
                throw new IllegalArgumentException("Provided CA private key doesn't correspond to provided CA certificate");
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        return certificates;
    }

    private boolean isCertPathOrderedCorrectly(List<X509Certificate> certificates) {
        for (int i = 0; i < certificates.size() - 1; ++i) {
            X509Certificate currentCert = certificates.get(i);
            X509Certificate nextCert = certificates.get(i + 1);
            if (currentCert.getIssuerX500Principal().equals(nextCert.getSubjectX500Principal())) continue;
            return false;
        }
        return true;
    }

    private List<X509Certificate> sortCertificates(List<X509Certificate> certificates) {
        X509Certificate[] sorted = new X509Certificate[certificates.size()];
        certificates.forEach(cert -> {
            int position = this.getChainPosition((X509Certificate)cert, certificates);
            if (sorted[position] != null) {
                throw new IllegalArgumentException("Corrupt certificate chain. Please make sure that your bundle only contains the CA and necessary intermediate/root certificates");
            }
            sorted[position] = cert;
        });
        List<X509Certificate> sortedList = Arrays.asList(sorted);
        Collections.reverse(sortedList);
        return sortedList;
    }

    private int getChainPosition(X509Certificate cert, List<X509Certificate> certificates) {
        int position = 0;
        X509Certificate currentCert = cert;
        for (int i = 0; i < certificates.size(); ++i) {
            X509Certificate issuerCert = this.findIssuer(currentCert, certificates);
            if (issuerCert == null) {
                return position;
            }
            currentCert = issuerCert;
            ++position;
        }
        throw new IllegalArgumentException("Corrupt certificate chain containing a signing loop.");
    }

    private X509Certificate findIssuer(X509Certificate cert, List<X509Certificate> certificates) {
        return certificates.stream().filter(potentialIssuer -> !potentialIssuer.getSubjectX500Principal().equals(cert.getSubjectX500Principal()) && potentialIssuer.getSubjectX500Principal().equals(cert.getIssuerX500Principal())).findFirst().orElse(null);
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }
}

