/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.ca;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.graylog.security.certutil.CertutilTruststore;
import org.graylog.security.certutil.ca.CA;
import org.graylog.security.certutil.ca.exceptions.CACreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PemCaReader {
    private static final Logger LOG = LoggerFactory.getLogger(PemCaReader.class);

    private static List<Object> readPemObjects(PEMParser pemParser) throws IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        Object pemObject;
        while ((pemObject = pemParser.readObject()) != null) {
            results.add(pemObject);
        }
        return Collections.unmodifiableList(results);
    }

    public static CA readCA(String pemFileContent, String keyPassword) throws CACreationException {
        StringReader bundleReader = new StringReader(pemFileContent);
        try {
            PEMParser pemParser = new PEMParser((Reader)bundleReader);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
            PrivateKey privateKey = null;
            List<Object> pemObjects = PemCaReader.readPemObjects(pemParser);
            for (Object pemObject : pemObjects) {
                if (pemObject instanceof X509Certificate) {
                    X509Certificate cert = (X509Certificate)pemObject;
                    LOG.info("Parsed certificate: {}", (Object)CertutilTruststore.certificateInfo(cert));
                    certificates.add(cert);
                    continue;
                }
                if (pemObject instanceof X509CertificateHolder) {
                    X509CertificateHolder cert = (X509CertificateHolder)pemObject;
                    certificates.add(new JcaX509CertificateConverter().getCertificate(cert));
                    continue;
                }
                if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                    PKCS8EncryptedPrivateKeyInfo encryptedPrivateKey = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                    if (keyPassword == null || keyPassword.isBlank()) {
                        throw new CACreationException("Private key is encrypted, but no password was supplied!");
                    }
                    JceOpenSSLPKCS8DecryptorProviderBuilder decryptorBuilder = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider("BC");
                    InputDecryptorProvider keyDecryptorBuilder = decryptorBuilder.build(keyPassword.toCharArray());
                    PrivateKeyInfo privateKeyInfo = encryptedPrivateKey.decryptPrivateKeyInfo(keyDecryptorBuilder);
                    privateKey = converter.getPrivateKey(privateKeyInfo);
                    continue;
                }
                if (pemObject instanceof PrivateKeyInfo) {
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)pemObject;
                    privateKey = converter.getPrivateKey(privateKeyInfo);
                    continue;
                }
                if (pemObject instanceof PEMKeyPair) {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)pemObject;
                    privateKey = converter.getPrivateKey(pemKeyPair.getPrivateKeyInfo());
                    continue;
                }
                if (!(pemObject instanceof PEMEncryptedKeyPair)) continue;
                PEMEncryptedKeyPair pemEncryptedKeyPair = (PEMEncryptedKeyPair)pemObject;
                if (keyPassword == null || keyPassword.isBlank()) {
                    throw new CACreationException("Private key is encrypted, but no password was supplied!");
                }
                PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider("BC").build(keyPassword.toCharArray());
                PrivateKeyInfo privateKeyInfo = pemEncryptedKeyPair.decryptKeyPair(decryptorProvider).getPrivateKeyInfo();
                privateKey = converter.getPrivateKey(privateKeyInfo);
            }
            if (privateKey == null) {
                throw new CACreationException("No private key supplied in CA bundle!");
            }
            if (certificates.isEmpty()) {
                throw new CACreationException("No certificate supplied in CA bundle!");
            }
            LOG.info("Certificate bundle contains {} certificates", (Object)certificates.size());
            CA cA = new CA(certificates, privateKey);
            bundleReader.close();
            return cA;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bundleReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (PKCSException e) {
                throw new CACreationException("Error while decrypting private key. Wrong password?", e);
            }
            catch (IOException | CertificateException | OperatorCreationException e) {
                throw new CACreationException("Failed to parse CA bundle: ", e);
            }
        }
    }
}

