/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.alerts;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import java.util.Map;
import org.graylog2.plugin.alarms.AlertCondition;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationException;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.streams.Stream;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertConditionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AlertConditionFactory.class);
    private final Map<String, AlertCondition.Factory> alertConditionMap;

    @Inject
    public AlertConditionFactory(Map<String, AlertCondition.Factory> alertConditionMap) {
        this.alertConditionMap = alertConditionMap;
    }

    public AlertCondition createAlertCondition(String type, Stream stream, String id, DateTime createdAt, String creatorId, Map<String, Object> parameters, String title) throws ConfigurationException {
        Object conditionTitle = Strings.isNullOrEmpty((String)title) ? "" : "'" + title + "' ";
        AlertCondition.Factory factory = this.alertConditionMap.get(type);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (String)"Unknown alert condition type <%s> for alert condition %s<%s> on stream \"%s\" <%s>", (Object[])new Object[]{type, conditionTitle, id, stream.getTitle(), stream.getId()});
        try {
            ConfigurationRequest requestedConfiguration = factory.config().getRequestedConfiguration();
            Configuration configuration = new Configuration(parameters);
            requestedConfiguration.check(configuration);
        }
        catch (ConfigurationException e) {
            LOG.error("Could not load alert condition {}<{}> on stream \"{}\" <{}>, invalid configuration detected.", new Object[]{conditionTitle, id, stream.getTitle(), stream.getId()});
            throw e;
        }
        return factory.create(stream, id, createdAt, creatorId, parameters, title);
    }
}

