/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.LinkedList;
import java.util.List;
import org.graylog2.storage.versionprobe.VersionProbeListener;

public class VersionProbeMessageCollector
implements VersionProbeListener {
    private final VersionProbeListener delegate;
    private final List<String> messages = new LinkedList<String>();

    public VersionProbeMessageCollector(VersionProbeListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onRetry(long attemptNumber, long configuredAttempts, @Nullable Throwable cause) {
        this.delegate.onRetry(attemptNumber, configuredAttempts, cause);
        if (cause != null) {
            this.messages.add(cause.getMessage());
        }
    }

    @Override
    public void onError(@Nonnull String message, @Nullable Throwable cause) {
        this.delegate.onError(message, cause);
        if (cause != null) {
            this.messages.add(message + ": " + cause.getMessage());
        } else {
            this.messages.add(message);
        }
    }

    public List<String> getMessages() {
        return this.messages;
    }

    @Nullable
    public String joinedMessages() {
        if (this.messages.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)";", this.messages);
    }
}

