/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.leader;

import com.google.inject.Scopes;
import org.graylog2.Configuration;
import org.graylog2.cluster.leader.AutomaticLeaderElectionService;
import org.graylog2.cluster.leader.LeaderElectionMode;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.cluster.leader.StaticLeaderElectionService;
import org.graylog2.plugin.PluginModule;

public class LeaderElectionModule
extends PluginModule {
    private final Configuration configuration;

    public LeaderElectionModule(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        LeaderElectionMode mode = this.configuration.getLeaderElectionMode();
        switch (mode) {
            case STATIC: {
                this.bind(LeaderElectionService.class).to(StaticLeaderElectionService.class).in(Scopes.SINGLETON);
                break;
            }
            case AUTOMATIC: {
                this.bind(LeaderElectionService.class).to(AutomaticLeaderElectionService.class).in(Scopes.SINGLETON);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown leader election mode \"" + String.valueOf((Object)mode) + "\".");
            }
        }
    }
}

