/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.util.Duration;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Suppliers;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graylog2.bootstrap.preflight.GraylogCertificateProvisioner;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerDiscoveryProvider
implements Provider<List<URI>> {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerDiscoveryProvider.class);
    public static final URI DEFAULT_INDEXER_HOST = URI.create("http://127.0.0.1:9200");
    private final List<URI> hosts;
    private final PreflightConfigService preflightConfigService;
    private final NodeService<DataNodeDto> nodeService;
    private final GraylogCertificateProvisioner graylogCertificateProvisioner;
    private final Supplier<List<URI>> resultsCachingSupplier;
    private final int connectionAttempts;
    private final Duration delayBetweenAttempts;

    @Inject
    public IndexerDiscoveryProvider(@Named(value="elasticsearch_hosts") List<URI> hosts, @Named(value="datanode_startup_connection_attempts") int connectionAttempts, @Named(value="datanode_startup_connection_delay") Duration delayBetweenAttempts, PreflightConfigService preflightConfigService, NodeService<DataNodeDto> nodeService, GraylogCertificateProvisioner graylogCertificateProvisioner) {
        this.hosts = hosts;
        this.connectionAttempts = connectionAttempts;
        this.delayBetweenAttempts = delayBetweenAttempts;
        this.preflightConfigService = preflightConfigService;
        this.nodeService = nodeService;
        this.graylogCertificateProvisioner = graylogCertificateProvisioner;
        this.resultsCachingSupplier = Suppliers.memoize(this::doGet);
    }

    public List<URI> get() {
        return this.resultsCachingSupplier.get();
    }

    private List<URI> doGet() {
        if (this.hosts != null && !this.hosts.isEmpty()) {
            return this.hosts;
        }
        PreflightConfigResult preflightResult = this.preflightConfigService.getPreflightConfigResult();
        if (preflightResult == PreflightConfigResult.FINISHED) {
            try {
                return (List)RetryerBuilder.newBuilder().retryIfResult(List::isEmpty).withRetryListener(new RetryListener(){

                    public void onRetry(Attempt attempt) {
                        if (!attempt.hasResult() || IndexerDiscoveryProvider.this.isEmptyList(attempt.getResult())) {
                            if (IndexerDiscoveryProvider.this.connectionAttempts == 0) {
                                LOG.info("Datanode is not available. Retry #{}", (Object)attempt.getAttemptNumber());
                            } else {
                                LOG.info("Datanode is not available. Retry #{}/{}", (Object)attempt.getAttemptNumber(), (Object)IndexerDiscoveryProvider.this.connectionAttempts);
                            }
                        }
                        IndexerDiscoveryProvider.this.graylogCertificateProvisioner.runProvisioning();
                    }
                }).withWaitStrategy(WaitStrategies.fixedWait((long)this.delayBetweenAttempts.getQuantity(), (TimeUnit)this.delayBetweenAttempts.getUnit())).withStopStrategy(this.connectionAttempts == 0 ? StopStrategies.neverStop() : StopStrategies.stopAfterAttempt((int)this.connectionAttempts)).build().call(this::discover);
            }
            catch (RetryException | ExecutionException e) {
                LOG.error("Unable to retrieve Datanode connection: ", e);
                throw new IllegalStateException("Unable to retrieve Datanode connection", e);
            }
        }
        LOG.info("No indexer hosts configured, using fallback {}", (Object)DEFAULT_INDEXER_HOST);
        return Collections.singletonList(DEFAULT_INDEXER_HOST);
    }

    private boolean isEmptyList(Object result) {
        return result instanceof List && ((List)result).isEmpty();
    }

    private List<URI> discover() {
        return this.nodeService.allActive().values().stream().map(Node::getTransportAddress).filter(address -> address != null && !address.isBlank()).map(URI::create).collect(Collectors.toList());
    }
}

