/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.graylog2.contentpacks.model.AutoValue_LegacyContentPack;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ContentPackV1;
import org.graylog2.contentpacks.model.ContentPackView;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.ModelVersion;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.parameters.Parameter;
import org.graylog2.security.html.HTMLSanitizerConverter;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LegacyContentPack
implements ContentPack {
    private static final ModelVersion VERSION = ModelVersion.of("0");
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SUMMARY = "summary";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_VENDOR = "vendor";
    private static final String FIELD_URL = "url";
    private static final String FIELD_REQUIRES = "requires";
    private static final String FIELD_PARAMETERS = "parameters";
    private static final String FIELD_ENTITIES = "entities";
    private static final String FIELD_DB_ID = "_id";
    private static final int DEFAULT_REVISION = 0;

    @Nullable
    @JsonView(value={ContentPackView.DBView.class})
    @JsonProperty(value="_id")
    public abstract ObjectId _id();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="name")
    public abstract String name();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="summary")
    public abstract String summary();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="description")
    @JsonSerialize(converter=HTMLSanitizerConverter.class)
    public abstract String description();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="vendor")
    public abstract String vendor();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="url")
    public abstract URI url();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="requires")
    public abstract ImmutableSet<Constraint> requires();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="parameters")
    public abstract ImmutableSet<Parameter> parameters();

    @JsonView(value={ContentPackView.HttpView.class})
    @JsonProperty(value="entities")
    public abstract ImmutableSet<Entity> entities();

    public ContentPackV1 toContentPackV1() {
        return ((ContentPackV1.Builder)((ContentPackV1.Builder)ContentPackV1.builder().id(this.id())).revision(this.revision())).name(this.name()).summary(this.summary()).description(this.description()).vendor(this.vendor()).url(this.url()).parameters(this.parameters()).entities(this.entities()).build();
    }

    static Builder builder() {
        return Builder.builder();
    }

    @AutoValue.Builder
    static abstract class Builder
    implements ContentPack.ContentPackBuilder<Builder> {
        private Collection<Entity> inputs = Collections.emptySet();
        private Collection<Entity> streams = Collections.emptySet();
        private Collection<Entity> outputs = Collections.emptySet();
        private Collection<Entity> grokPatterns = Collections.emptySet();
        private Collection<Entity> lookupTables = Collections.emptySet();
        private Collection<Entity> lookupCaches = Collections.emptySet();
        private Collection<Entity> lookupDataAdapters = Collections.emptySet();

        Builder() {
        }

        @JsonCreator
        static Builder builder() {
            return new AutoValue_LegacyContentPack.Builder().id(ModelId.of(UUID.randomUUID().toString()));
        }

        @JsonProperty(value="_id")
        abstract Builder _id(ObjectId var1);

        @JsonProperty(value="name")
        abstract Builder name(String var1);

        @JsonProperty(value="summary")
        abstract Builder summary(String var1);

        @JsonProperty(value="description")
        abstract Builder description(String var1);

        @JsonProperty(value="vendor")
        abstract Builder vendor(String var1);

        @JsonProperty(value="url")
        abstract Builder url(URI var1);

        @JsonProperty(value="requires")
        abstract Builder requires(ImmutableSet<Constraint> var1);

        @JsonProperty(value="parameters")
        abstract Builder parameters(ImmutableSet<Parameter> var1);

        @JsonProperty(value="entities")
        abstract Builder entities(ImmutableSet<Entity> var1);

        @JsonProperty(value="category")
        Builder category(String category) {
            return this;
        }

        @JsonProperty(value="inputs")
        Builder inputs(Collection<JsonNode> inputs) {
            this.inputs = this.convertInputs(inputs);
            return this;
        }

        @JsonProperty(value="streams")
        Builder streams(Collection<JsonNode> streams) {
            this.streams = this.convertStreams(streams);
            return this;
        }

        @JsonProperty(value="outputs")
        Builder outputs(Collection<JsonNode> outputs) {
            this.outputs = this.convertOutputs(outputs);
            return this;
        }

        @JsonProperty(value="dashboards")
        Builder dashboards(Collection<JsonNode> dashboards) {
            return this;
        }

        @JsonProperty(value="grok_patterns")
        Builder grokPatterns(Collection<JsonNode> grokPatterns) {
            this.grokPatterns = this.convertGrokPatterns(grokPatterns);
            return this;
        }

        @JsonProperty(value="lookup_tables")
        Builder lookupTables(Collection<JsonNode> lookupTables) {
            this.lookupTables = this.convertLookupTables(lookupTables);
            return this;
        }

        @JsonProperty(value="lookup_caches")
        Builder lookupCaches(Collection<JsonNode> lookupCaches) {
            this.lookupCaches = this.convertLookupCaches(lookupCaches);
            return this;
        }

        @JsonProperty(value="lookup_data_adapters")
        Builder lookupDataAdapters(Collection<JsonNode> lookupDataAdapters) {
            this.lookupDataAdapters = this.convertLookupDataAdapters(lookupDataAdapters);
            return this;
        }

        abstract LegacyContentPack autoBuild();

        public LegacyContentPack build() {
            ImmutableSet entities = ImmutableSet.builder().addAll(this.inputs).addAll(this.streams).addAll(this.outputs).addAll(this.grokPatterns).addAll(this.lookupTables).addAll(this.lookupCaches).addAll(this.lookupDataAdapters).build();
            this.version(VERSION);
            this.revision(0);
            this.summary("[auto-generated]");
            this.vendor("[auto-generated]");
            this.url(URI.create("https://www.graylog.org/"));
            this.requires((ImmutableSet<Constraint>)ImmutableSet.of());
            this.parameters((ImmutableSet<Parameter>)ImmutableSet.of());
            this.entities((ImmutableSet<Entity>)entities);
            return this.autoBuild();
        }

        private Collection<Entity> convertInputs(Collection<JsonNode> inputs) {
            if (inputs == null || inputs.isEmpty()) {
                return Collections.emptySet();
            }
            return inputs.stream().map(this::convertInput).collect(Collectors.toSet());
        }

        private Entity convertInput(JsonNode json) {
            return ((EntityV1.Builder)((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(json.path("id").asText(UUID.randomUUID().toString())))).type(ModelTypes.INPUT_V1)).version(ModelVersion.of("1"))).data(json).build();
        }

        private Collection<Entity> convertStreams(Collection<JsonNode> streams) {
            if (streams == null || streams.isEmpty()) {
                return Collections.emptySet();
            }
            return streams.stream().map(this::convertStream).collect(Collectors.toSet());
        }

        private Entity convertStream(JsonNode json) {
            return ((EntityV1.Builder)((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(json.path("id").asText(UUID.randomUUID().toString())))).type(ModelTypes.STREAM_V1)).version(ModelVersion.of("1"))).data(json).build();
        }

        private Collection<Entity> convertOutputs(Collection<JsonNode> outputs) {
            if (outputs == null || outputs.isEmpty()) {
                return Collections.emptySet();
            }
            return outputs.stream().map(this::convertOutput).collect(Collectors.toSet());
        }

        private Entity convertOutput(JsonNode json) {
            return ((EntityV1.Builder)((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(json.path("id").asText(UUID.randomUUID().toString())))).type(ModelTypes.OUTPUT_V1)).version(ModelVersion.of("1"))).data(json).build();
        }

        private Collection<Entity> convertGrokPatterns(Collection<JsonNode> grokPatterns) {
            if (grokPatterns == null || grokPatterns.isEmpty()) {
                return Collections.emptySet();
            }
            return grokPatterns.stream().map(this::convertGrokPattern).collect(Collectors.toSet());
        }

        private Entity convertGrokPattern(JsonNode json) {
            return ((EntityV1.Builder)((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(json.path(LegacyContentPack.FIELD_NAME).asText(UUID.randomUUID().toString())))).type(ModelTypes.GROK_PATTERN_V1)).version(ModelVersion.of("1"))).data(json).build();
        }

        private Collection<Entity> convertLookupTables(Collection<JsonNode> lookupTables) {
            if (lookupTables == null || lookupTables.isEmpty()) {
                return Collections.emptySet();
            }
            return lookupTables.stream().map(this::convertLookupTable).collect(Collectors.toSet());
        }

        private Entity convertLookupTable(JsonNode json) {
            return ((EntityV1.Builder)((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(json.path(LegacyContentPack.FIELD_NAME).asText(UUID.randomUUID().toString())))).type(ModelTypes.LOOKUP_TABLE_V1)).version(ModelVersion.of("1"))).data(json).build();
        }

        private Collection<Entity> convertLookupCaches(Collection<JsonNode> lookupCaches) {
            if (lookupCaches == null || lookupCaches.isEmpty()) {
                return Collections.emptySet();
            }
            return lookupCaches.stream().map(this::convertLookupCache).collect(Collectors.toSet());
        }

        private Entity convertLookupCache(JsonNode json) {
            return ((EntityV1.Builder)((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(json.path(LegacyContentPack.FIELD_NAME).asText(UUID.randomUUID().toString())))).type(ModelTypes.LOOKUP_CACHE_V1)).version(ModelVersion.of("1"))).data(json).build();
        }

        private Collection<Entity> convertLookupDataAdapters(Collection<JsonNode> lookupDataAdapters) {
            if (lookupDataAdapters == null || lookupDataAdapters.isEmpty()) {
                return Collections.emptySet();
            }
            return lookupDataAdapters.stream().map(this::convertLookupDataAdapter).collect(Collectors.toSet());
        }

        private Entity convertLookupDataAdapter(JsonNode json) {
            return ((EntityV1.Builder)((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(json.path(LegacyContentPack.FIELD_NAME).asText(UUID.randomUUID().toString())))).type(ModelTypes.LOOKUP_ADAPTER_V1)).version(ModelVersion.of("1"))).data(json).build();
        }
    }
}

