/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog2.contentpacks.NativeEntityConverter;
import org.graylog2.contentpacks.model.entities.AutoValue_SearchEntity;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SearchEntity
implements NativeEntityConverter<Search> {
    public static final String FIELD_REQUIRES = "requires";
    private static final String FIELD_CREATED_AT = "created_at";
    public static final String FIELD_OWNER = "owner";

    @JsonProperty
    public abstract ImmutableSet<QueryEntity> queries();

    @JsonProperty
    public abstract ImmutableSet<Parameter> parameters();

    @JsonProperty(value="requires")
    public abstract Map<String, PluginMetadataSummary> requires();

    @JsonProperty(value="owner")
    public abstract Optional<String> owner();

    @JsonProperty(value="created_at")
    public abstract DateTime createdAt();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.create().parameters((ImmutableSet<Parameter>)ImmutableSet.of()).queries((ImmutableSet<QueryEntity>)ImmutableSet.builder().build());
    }

    public Set<String> usedStreamIds() {
        Set queryStreamIds = this.queries().stream().map(QueryEntity::usedStreamIds).reduce(Collections.emptySet(), Sets::union);
        Set searchTypeStreamIds = this.queries().stream().flatMap(q -> q.searchTypes().stream()).map(SearchTypeEntity::effectiveStreams).reduce(Collections.emptySet(), Sets::union);
        return Sets.union((Set)queryStreamIds, (Set)searchTypeStreamIds);
    }

    @Override
    public Search toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        LinkedHashSet queries = this.queries().stream().map(q -> q.toNativeEntity((Map)parameters, (Map)nativeEntities)).collect(Collectors.toCollection(LinkedHashSet::new));
        Search.Builder searchBuilder = Search.builder().queries((ImmutableSet<Query>)ImmutableSet.copyOf((Collection)queries)).parameters(this.parameters()).requires(this.requires()).createdAt(this.createdAt());
        if (this.owner().isPresent()) {
            searchBuilder.owner(this.owner().get());
        }
        return searchBuilder.build();
    }

    @Override
    public void resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities, MutableGraph<Entity> graph) {
        this.queries().forEach(query -> query.resolveForInstallation(entity, parameters, entities, graph));
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder queries(ImmutableSet<QueryEntity> var1);

        @JsonProperty
        public abstract Builder parameters(ImmutableSet<Parameter> var1);

        @JsonProperty(value="requires")
        public abstract Builder requires(Map<String, PluginMetadataSummary> var1);

        @JsonProperty(value="owner")
        public abstract Builder owner(@Nullable String var1);

        @JsonProperty(value="created_at")
        public abstract Builder createdAt(DateTime var1);

        public abstract SearchEntity build();

        @JsonCreator
        public static Builder create() {
            return new AutoValue_SearchEntity.Builder().requires(Collections.emptyMap()).createdAt(DateTime.now((DateTimeZone)DateTimeZone.UTC)).parameters((ImmutableSet<Parameter>)ImmutableSet.of());
        }
    }
}

