/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.counts;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.List;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.counts.CountsAdapter;

@Singleton
public class Counts {
    private final IndexSetRegistry indexSetRegistry;
    private final CountsAdapter countsAdapter;

    @Inject
    public Counts(IndexSetRegistry indexSetRegistry, CountsAdapter countsAdapter) {
        this.indexSetRegistry = indexSetRegistry;
        this.countsAdapter = countsAdapter;
    }

    public long total() {
        return this.totalCount(this.indexSetRegistry.getManagedIndices());
    }

    public long total(IndexSet indexSet) {
        return this.totalCount(indexSet.getManagedIndices());
    }

    private long totalCount(String[] indexNames) {
        if (indexNames.length == 0) {
            return 0L;
        }
        List<String> indices = Arrays.asList(indexNames);
        return this.countsAdapter.totalCount(indices);
    }
}

