/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import jakarta.inject.Inject;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.graylog2.datatiering.DataTieringChecker;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.template.IndexSetDefaultTemplateService;
import org.graylog2.indexer.indexset.template.IndexSetTemplateConfig;

public class IndexSetConfigFactory {
    private final DataTieringChecker dataTieringChecker;
    private final IndexSetDefaultTemplateService indexSetDefaultTemplateService;

    @Inject
    public IndexSetConfigFactory(DataTieringChecker dataTieringChecker, IndexSetDefaultTemplateService indexSetDefaultTemplateService) {
        this.dataTieringChecker = dataTieringChecker;
        this.indexSetDefaultTemplateService = indexSetDefaultTemplateService;
    }

    private static ZonedDateTime getCreationDate() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    private static DataTieringConfig getDataTieringConfig(IndexSetTemplateConfig defaultConfig) {
        return defaultConfig.useLegacyRotation() != false ? null : defaultConfig.dataTieringConfig();
    }

    public IndexSetConfig.Builder createDefault() {
        IndexSetTemplateConfig defaultConfig = this.indexSetDefaultTemplateService.getOrCreateDefaultConfig();
        return IndexSetConfig.builder().creationDate(IndexSetConfigFactory.getCreationDate()).indexAnalyzer(defaultConfig.indexAnalyzer()).shards(defaultConfig.shards()).replicas(defaultConfig.replicas()).indexOptimizationDisabled(defaultConfig.indexOptimizationDisabled()).indexOptimizationMaxNumSegments(defaultConfig.indexOptimizationMaxNumSegments()).fieldTypeRefreshInterval(defaultConfig.fieldTypeRefreshInterval()).rotationStrategyClass(defaultConfig.rotationStrategyClass()).rotationStrategyConfig(defaultConfig.rotationStrategyConfig()).retentionStrategyClass(defaultConfig.retentionStrategyClass()).retentionStrategyConfig(defaultConfig.retentionStrategyConfig()).dataTieringConfig(this.dataTieringChecker.isEnabled() ? IndexSetConfigFactory.getDataTieringConfig(defaultConfig) : null);
    }
}

