/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset.template;

import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import java.util.Optional;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.configuration.IndexSetDefaultTemplateConfigFactory;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.indexset.template.IndexSetDefaultTemplate;
import org.graylog2.indexer.indexset.template.IndexSetTemplate;
import org.graylog2.indexer.indexset.template.IndexSetTemplateConfig;
import org.graylog2.indexer.indexset.template.IndexSetTemplateService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSetDefaultTemplateService {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetDefaultTemplateService.class);
    private final ClusterConfigService clusterConfigService;
    private final IndexSetTemplateService indexSetTemplateService;
    private final IndexSetDefaultTemplateConfigFactory indexSetDefaultTemplateConfigFactory;
    private final AuditEventSender auditEventSender;

    @Inject
    public IndexSetDefaultTemplateService(ClusterConfigService clusterConfigService, IndexSetTemplateService indexSetTemplateService, IndexSetDefaultTemplateConfigFactory indexSetDefaultTemplateConfigFactory, AuditEventSender auditEventSender) {
        this.clusterConfigService = clusterConfigService;
        this.indexSetTemplateService = indexSetTemplateService;
        this.indexSetDefaultTemplateConfigFactory = indexSetDefaultTemplateConfigFactory;
        this.auditEventSender = auditEventSender;
    }

    public Optional<IndexSetTemplate> getDefaultIndexSetTemplate() {
        return this.getIndexSetDefaultTemplateConfig().flatMap(indexSetDefaultTemplate -> this.indexSetTemplateService.get(indexSetDefaultTemplate.id()));
    }

    public IndexSetTemplateConfig getOrCreateDefaultConfig() {
        return this.getDefaultIndexSetTemplate().map(IndexSetTemplate::indexSetConfig).orElse(this.createDefault());
    }

    public IndexSetTemplate createAndSaveDefault(IndexSetTemplate defaultIndexSetTemplate) {
        IndexSetTemplate savedTemplate = this.indexSetTemplateService.save(defaultIndexSetTemplate);
        this.clusterConfigService.write(new IndexSetDefaultTemplate(savedTemplate.id()));
        return savedTemplate;
    }

    public void setDefault(@NotNull IndexSetDefaultTemplate defaultTemplate, String userName) throws NotFoundException {
        Optional<IndexSetTemplate> indexSetTemplate = this.indexSetTemplateService.get(defaultTemplate.id());
        if (indexSetTemplate.isEmpty()) {
            throw new NotFoundException("Index template with id <%s> doesn't exist!".formatted(defaultTemplate.id()));
        }
        if (indexSetTemplate.get().isBuiltIn()) {
            throw new IllegalArgumentException("Built-in templates cannot be set as default!");
        }
        this.clusterConfigService.write(defaultTemplate);
        this.auditEventSender.success(AuditActor.user(userName), "server:index_set_default_template:update", (Map<String, Object>)ImmutableMap.of((Object)"template_id", (Object)indexSetTemplate.get().id(), (Object)"template_title", (Object)indexSetTemplate.get().title()));
    }

    @Nullable
    public String getDefaultIndexSetTemplateId() {
        return this.getIndexSetDefaultTemplateConfig().map(IndexSetDefaultTemplate::id).orElse(null);
    }

    private Optional<IndexSetDefaultTemplate> getIndexSetDefaultTemplateConfig() {
        return Optional.ofNullable(this.clusterConfigService.get(IndexSetDefaultTemplate.class));
    }

    private IndexSetTemplateConfig createDefault() {
        LOG.debug("Could not find default configuration. Falling back to server configuration values.");
        return this.indexSetDefaultTemplateConfigFactory.create();
    }
}

