/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import java.util.List;

public class DynamicSizeListPartitioner<T> {
    private final List<T> list;
    private int offset;

    public DynamicSizeListPartitioner(List<T> list) {
        this.list = list;
        this.offset = 0;
    }

    public List<T> nextPartition(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Partition size must be greater than 0");
        }
        if (this.offset >= this.list.size()) {
            return List.of();
        }
        int nextOffset = Math.min(this.offset + size, this.list.size());
        List<T> partition = this.list.subList(this.offset, nextOffset);
        this.offset = nextOffset;
        return partition;
    }

    public boolean hasNext() {
        return this.offset < this.list.size();
    }
}

