/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.messages;

import com.github.joschi.jadconfig.util.Duration;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.WaitStrategies;
import com.github.rholder.retry.WaitStrategy;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import org.graylog2.indexer.messages.GenericRetryAttempt;

public class RetryWait {
    static final Duration MAX_WAIT_TIME = Duration.seconds((long)30L);
    @VisibleForTesting
    final WaitStrategy waitStrategy;

    public RetryWait(int retrySecondsMultiplier) {
        this.waitStrategy = WaitStrategies.exponentialWait((long)retrySecondsMultiplier, (long)MAX_WAIT_TIME.getQuantity(), (TimeUnit)MAX_WAIT_TIME.getUnit());
    }

    public void waitBeforeRetrying(long attempt) {
        try {
            long sleepTime = this.waitStrategy.computeSleepTime((Attempt)new GenericRetryAttempt(attempt));
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

