/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputImpl;
import org.graylog2.inputs.InputService;
import org.graylog2.inputs.converters.ConverterFactory;
import org.graylog2.inputs.encryption.EncryptedInputConfigs;
import org.graylog2.inputs.extractors.ExtractorFactory;
import org.graylog2.inputs.extractors.events.ExtractorCreated;
import org.graylog2.inputs.extractors.events.ExtractorDeleted;
import org.graylog2.inputs.extractors.events.ExtractorUpdated;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.database.EmbeddedPersistable;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.inputs.Converter;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.rest.models.system.inputs.responses.InputCreated;
import org.graylog2.rest.models.system.inputs.responses.InputDeleted;
import org.graylog2.rest.models.system.inputs.responses.InputUpdated;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueMapperConfig;
import org.graylog2.shared.inputs.MessageInputFactory;
import org.graylog2.shared.inputs.NoSuchInputTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputServiceImpl
extends PersistedServiceImpl
implements InputService {
    private static final Logger LOG = LoggerFactory.getLogger(InputServiceImpl.class);
    private final ExtractorFactory extractorFactory;
    private final ConverterFactory converterFactory;
    private final MessageInputFactory messageInputFactory;
    private final EventBus clusterEventBus;
    private final DBCollection dbCollection;
    private final ObjectMapper objectMapper;

    @Inject
    public InputServiceImpl(MongoConnection mongoConnection, ExtractorFactory extractorFactory, ConverterFactory converterFactory, MessageInputFactory messageInputFactory, ClusterEventBus clusterEventBus, ObjectMapper objectMapper) {
        super(mongoConnection);
        this.extractorFactory = extractorFactory;
        this.converterFactory = converterFactory;
        this.messageInputFactory = messageInputFactory;
        this.clusterEventBus = clusterEventBus;
        this.dbCollection = this.collection(InputImpl.class);
        this.objectMapper = objectMapper.copy();
        EncryptedValueMapperConfig.enableDatabase(this.objectMapper);
    }

    @Override
    public List<Input> all() {
        List<DBObject> ownInputs = this.query(InputImpl.class, (DBObject)new BasicDBObject());
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (DBObject o : ownInputs) {
            inputs.add((Object)this.createFromDbObject(o));
        }
        return inputs.build();
    }

    @Override
    public List<Input> allOfThisNode(String nodeId) {
        ImmutableList query = ImmutableList.of((Object)new BasicDBObject("node_id", (Object)nodeId), (Object)new BasicDBObject("global", (Object)true));
        List<DBObject> ownInputs = this.query(InputImpl.class, (DBObject)new BasicDBObject("$or", (Object)query));
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (DBObject o : ownInputs) {
            inputs.add((Object)this.createFromDbObject(o));
        }
        return inputs.build();
    }

    @Override
    public List<Input> allByType(String type) {
        ImmutableList.Builder inputs = ImmutableList.builder();
        for (DBObject o : this.query(InputImpl.class, (DBObject)new BasicDBObject("type", (Object)type))) {
            inputs.add((Object)this.createFromDbObject(o));
        }
        return inputs.build();
    }

    @Override
    public Set<Input> findByIds(Collection<String> ids) {
        Set objectIds = ids.stream().map(ObjectId::new).collect(Collectors.toSet());
        DBObject query = BasicDBObjectBuilder.start().push("_id").append("$in", objectIds).get();
        Stream<InputImpl> inputStream = this.query(InputImpl.class, query).stream().map(o -> this.createFromDbObject((DBObject)o));
        return inputStream.collect(Collectors.toSet());
    }

    @Override
    public <T extends Persisted> String save(T model) throws ValidationException {
        return this.save(model, true);
    }

    @Override
    public <T extends Persisted> String saveWithoutEvents(T model) throws ValidationException {
        return this.save(model, false);
    }

    private <T extends Persisted> String save(T model, boolean fireEvents) throws ValidationException {
        String resultId = super.save(model);
        if (resultId != null && !resultId.isEmpty() && fireEvents) {
            this.publishChange(InputCreated.create(resultId));
        }
        return resultId;
    }

    @Override
    public String update(Input model) throws ValidationException {
        String resultId = super.save(model);
        if (resultId != null && !resultId.isEmpty()) {
            this.publishChange(InputUpdated.create(resultId));
        }
        return resultId;
    }

    @Override
    public <T extends Persisted> String saveWithoutValidation(T model) {
        String resultId = super.saveWithoutValidation(model);
        if (resultId != null && !resultId.isEmpty()) {
            this.publishChange(InputCreated.create(resultId));
        }
        return resultId;
    }

    @Override
    public <T extends Persisted> int destroy(T model) {
        int result = super.destroy(model);
        if (result > 0) {
            this.publishChange(InputDeleted.create(model.getId()));
        }
        return result;
    }

    @Override
    public Input create(String id, Map<String, Object> fields) {
        return new InputImpl(new ObjectId(id), fields);
    }

    @Override
    public Input create(Map<String, Object> fields) {
        return new InputImpl(fields);
    }

    @Override
    public Input find(String id) throws NotFoundException {
        if (!ObjectId.isValid((String)id)) {
            throw new NotFoundException("Input id <" + id + "> is invalid!");
        }
        DBObject o = this.get(InputImpl.class, id);
        if (o == null) {
            throw new NotFoundException("Input <" + id + "> not found!");
        }
        return this.createFromDbObject(o);
    }

    @Override
    public Input findForThisNodeOrGlobal(String nodeId, String id) throws NotFoundException {
        ImmutableList forThisNodeOrGlobal = ImmutableList.of((Object)new BasicDBObject("node_id", (Object)nodeId), (Object)new BasicDBObject("global", (Object)true));
        ImmutableList query = ImmutableList.of((Object)new BasicDBObject("_id", (Object)new ObjectId(id)), (Object)new BasicDBObject("$or", (Object)forThisNodeOrGlobal));
        DBObject o = this.findOne(InputImpl.class, (DBObject)new BasicDBObject("$and", (Object)query));
        return this.createFromDbObject(o);
    }

    @Override
    public Input findForThisNode(String nodeId, String id) throws NotFoundException, IllegalArgumentException {
        ImmutableList forThisNode = ImmutableList.of((Object)new BasicDBObject("node_id", (Object)nodeId), (Object)new BasicDBObject("global", (Object)false));
        ImmutableList query = ImmutableList.of((Object)new BasicDBObject("_id", (Object)new ObjectId(id)), (Object)new BasicDBObject("$and", (Object)forThisNode));
        DBObject o = this.findOne(InputImpl.class, (DBObject)new BasicDBObject("$and", (Object)query));
        if (o == null) {
            throw new NotFoundException("Couldn't find input " + id + " on Graylog node " + nodeId);
        }
        return this.createFromDbObject(o);
    }

    @Override
    public void addExtractor(Input input, Extractor extractor) throws ValidationException {
        this.embed(input, "extractors", extractor);
        this.publishChange(ExtractorCreated.create(input.getId(), extractor.getId()));
    }

    @Override
    public void updateExtractor(Input input, Extractor extractor) throws ValidationException {
        this.removeEmbedded(input, "extractors", extractor.getId());
        this.embed(input, "extractors", extractor);
        this.publishChange(ExtractorUpdated.create(input.getId(), extractor.getId()));
    }

    @Override
    public void addStaticField(Input input, String key, String value) throws ValidationException {
        EmbeddedPersistable obj = () -> ImmutableMap.of((Object)"key", (Object)key, (Object)"value", (Object)value);
        this.embed(input, "static_fields", obj);
        this.publishChange(InputUpdated.create(input.getId()));
    }

    @Override
    public List<Map.Entry<String, String>> getStaticFields(Input input) {
        if (input.getFields().get("static_fields") == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        BasicDBList mSF = (BasicDBList)input.getFields().get("static_fields");
        for (Object element : mSF) {
            BasicDBObject ex = (BasicDBObject)element;
            try {
                Map.Entry staticField = Maps.immutableEntry((Object)((String)ex.get("key")), (Object)((String)ex.get("value")));
                listBuilder.add((Object)staticField);
            }
            catch (Exception e) {
                LOG.error("Cannot build static field from persisted data. Skipping.", (Throwable)e);
            }
        }
        return listBuilder.build();
    }

    @Override
    public List<Extractor> getExtractors(Input input) {
        if (input.getFields().get("extractors") == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        BasicDBList mEx = (BasicDBList)input.getFields().get("extractors");
        for (Object element : mEx) {
            BasicDBObject ex = (BasicDBObject)element;
            Long order = 0L;
            if (ex.containsField("order")) {
                Number num = (Number)ex.get("order");
                order = num.longValue();
            }
            try {
                Extractor extractor = this.extractorFactory.factory((String)ex.get("id"), (String)ex.get("title"), order.intValue(), Extractor.CursorStrategy.valueOf(((String)ex.get("cursor_strategy")).toUpperCase(Locale.ENGLISH)), Extractor.Type.valueOf(((String)ex.get("type")).toUpperCase(Locale.ENGLISH)), (String)ex.get("source_field"), (String)ex.get("target_field"), (Map)ex.get("extractor_config"), (String)ex.get("creator_user_id"), this.getConvertersOfExtractor((DBObject)ex), Extractor.ConditionType.valueOf(((String)ex.get("condition_type")).toUpperCase(Locale.ENGLISH)), (String)ex.get("condition_value"));
                listBuilder.add((Object)extractor);
            }
            catch (Exception e) {
                LOG.error("Cannot build extractor from persisted data. Skipping.", (Throwable)e);
            }
        }
        return listBuilder.build();
    }

    @Override
    public Extractor getExtractor(Input input, final String extractorId) throws NotFoundException {
        Optional extractor = Iterables.tryFind(this.getExtractors(input), (Predicate)new Predicate<Extractor>(){

            public boolean apply(Extractor extractor) {
                return extractor.getId().equals(extractorId);
            }
        });
        if (!extractor.isPresent()) {
            LOG.error("Extractor <{}> not found.", (Object)extractorId);
            throw new NotFoundException("Couldn't find extractor " + extractorId);
        }
        return (Extractor)extractor.get();
    }

    private List<Converter> getConvertersOfExtractor(DBObject extractor) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        BasicDBList converters = (BasicDBList)extractor.get("converters");
        for (Object element : converters) {
            BasicDBObject c = (BasicDBObject)element;
            try {
                listBuilder.add((Object)this.converterFactory.create(Converter.Type.valueOf(((String)c.get("type")).toUpperCase(Locale.ENGLISH)), (Map)c.get("config")));
            }
            catch (ConverterFactory.NoSuchConverterException e1) {
                LOG.error("Cannot build converter from persisted data. No such converter.", (Throwable)e1);
            }
            catch (Exception e) {
                LOG.error("Cannot build converter from persisted data.", (Throwable)e);
            }
        }
        return listBuilder.build();
    }

    @Override
    public void removeExtractor(Input input, String extractorId) {
        this.removeEmbedded(input, "extractors", extractorId);
        this.publishChange(ExtractorDeleted.create(input.getId(), extractorId));
    }

    @Override
    public void removeStaticField(Input input, String key) {
        this.removeEmbedded(input, "key", "static_fields", key);
        this.publishChange(InputUpdated.create(input.getId()));
    }

    @Override
    public MessageInput getMessageInput(Input io) throws NoSuchInputTypeException {
        Configuration configuration = new Configuration(io.getConfiguration());
        MessageInput input = this.messageInputFactory.create(io.getType(), configuration);
        input.setTitle(io.getTitle());
        input.setNodeId(io.getNodeId());
        input.setCreatorUserId(io.getCreatorUserId());
        input.setPersistId(io.getId());
        input.setCreatedAt(io.getCreatedAt());
        input.setContentPack(io.getContentPack());
        input.setDesiredState(io.getDesiredState());
        if (io.isGlobal().booleanValue()) {
            input.setGlobal(true);
        }
        input.addStaticFields(io.getStaticFields());
        return input;
    }

    @Override
    public long totalCount() {
        return this.totalCount(InputImpl.class);
    }

    @Override
    public long globalCount() {
        return this.count(InputImpl.class, (DBObject)new BasicDBObject("global", (Object)true));
    }

    @Override
    public long localCount() {
        return this.count(InputImpl.class, (DBObject)new BasicDBObject("global", (Object)false));
    }

    @Override
    public Map<String, Long> totalCountByType() {
        HashMap<String, Long> inputCountByType = new HashMap<String, Long>();
        try (DBCursor inputTypes = this.dbCollection.find(null, (DBObject)new BasicDBObject("type", (Object)1));){
            for (DBObject inputType : inputTypes) {
                String type = (String)inputType.get("type");
                if (type == null) continue;
                Long oldValue = (Long)inputCountByType.get(type);
                Long newValue = oldValue == null ? 1L : oldValue + 1L;
                inputCountByType.put(type, newValue);
            }
        }
        return inputCountByType;
    }

    @Override
    public long localCountForNode(String nodeId) {
        ImmutableList forThisNode = ImmutableList.of((Object)new BasicDBObject("node_id", (Object)nodeId));
        ImmutableList query = ImmutableList.of((Object)new BasicDBObject("global", (Object)false), (Object)new BasicDBObject("$or", (Object)forThisNode));
        return this.count(InputImpl.class, (DBObject)new BasicDBObject("$and", (Object)query));
    }

    @Override
    public long totalCountForNode(String nodeId) {
        ImmutableList query = ImmutableList.of((Object)new BasicDBObject("global", (Object)true), (Object)new BasicDBObject("node_id", (Object)nodeId));
        return this.count(InputImpl.class, (DBObject)new BasicDBObject("$or", (Object)query));
    }

    @Override
    public long totalExtractorCount() {
        BasicDBObject query = new BasicDBObject("extractors", (Object)new BasicDBObject("$exists", (Object)true));
        long extractorsCount = 0L;
        try (DBCursor inputs = this.dbCollection.find((DBObject)query, (DBObject)new BasicDBObject("extractors", (Object)1));){
            for (DBObject input : inputs) {
                BasicDBList extractors = (BasicDBList)input.get("extractors");
                extractorsCount += (long)extractors.size();
            }
        }
        return extractorsCount;
    }

    @Override
    public Map<Extractor.Type, Long> totalExtractorCountByType() {
        BasicDBObject query = new BasicDBObject("extractors", (Object)new BasicDBObject("$exists", (Object)true));
        try (DBCursor inputs = this.dbCollection.find((DBObject)query, (DBObject)new BasicDBObject("extractors", (Object)1));){
            HashMap<Extractor.Type, Long> extractorsCountByType = new HashMap<Extractor.Type, Long>();
            for (DBObject input : inputs) {
                BasicDBList extractors = (BasicDBList)input.get("extractors");
                for (Object dbObject : extractors) {
                    DBObject extractor = (DBObject)dbObject;
                    Extractor.Type type = Extractor.Type.fuzzyValueOf((String)extractor.get("type"));
                    if (type == null) continue;
                    Long oldValue = (Long)extractorsCountByType.get((Object)type);
                    Long newValue = oldValue == null ? 1L : oldValue + 1L;
                    extractorsCountByType.put(type, newValue);
                }
            }
            HashMap<Extractor.Type, Long> hashMap = extractorsCountByType;
            return hashMap;
        }
    }

    private void publishChange(Object event) {
        this.clusterEventBus.post(event);
    }

    private InputImpl createFromDbObject(DBObject o) {
        HashMap<String, Object> inputMap = new HashMap<String, Object>(o.toMap());
        String type = (String)inputMap.get("type");
        Set<String> encryptedFields = this.getEncryptedFields(type);
        if (encryptedFields.isEmpty()) {
            return new InputImpl((ObjectId)inputMap.get("_id"), inputMap);
        }
        HashMap config = new HashMap((Map)inputMap.get("configuration"));
        encryptedFields.forEach(field -> {
            EncryptedValue encryptedValue = (EncryptedValue)this.objectMapper.convertValue(config.get(field), EncryptedValue.class);
            config.put(field, encryptedValue);
        });
        inputMap.put("configuration", config);
        return new InputImpl((ObjectId)inputMap.get("_id"), inputMap);
    }

    private Set<String> getEncryptedFields(String type) {
        return this.messageInputFactory.getConfig(type).map(EncryptedInputConfigs::getEncryptedFields).orElse(Set.of());
    }

    @Override
    protected void fieldTransformations(Map<String, Object> doc) {
        for (Map.Entry<String, Object> x : doc.entrySet()) {
            Object object = x.getValue();
            if (!(object instanceof EncryptedValue)) continue;
            EncryptedValue encryptedValue = (EncryptedValue)object;
            doc.put(x.getKey(), this.objectMapper.convertValue((Object)encryptedValue, TypeReferences.MAP_STRING_OBJECT));
            return;
        }
        super.fieldTransformations(doc);
    }
}

