/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import io.netty.channel.ChannelFactory;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import org.graylog2.inputs.transports.netty.NettyTransportType;

public class DatagramChannelFactory
implements ChannelFactory<DatagramChannel> {
    private final NettyTransportType transportType;

    public DatagramChannelFactory(NettyTransportType transportType) {
        this.transportType = transportType;
    }

    public DatagramChannel newChannel() {
        switch (this.transportType) {
            case EPOLL: {
                return new EpollDatagramChannel();
            }
            case KQUEUE: {
                return new KQueueDatagramChannel();
            }
            case NIO: {
                return new NioDatagramChannel();
            }
        }
        throw new IllegalArgumentException("Invalid or unknown Netty transport type " + String.valueOf((Object)this.transportType));
    }
}

