/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.InstrumentedThreadFactory;
import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import jakarta.inject.Inject;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.graylog2.inputs.transports.NettyTransportConfiguration;
import org.graylog2.plugin.LocalMetricRegistry;

public class EventLoopGroupFactory {
    private final NettyTransportConfiguration configuration;

    @Inject
    public EventLoopGroupFactory(NettyTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public EventLoopGroup create(int numThreads, MetricRegistry metricRegistry, String metricPrefix) {
        ThreadFactory threadFactory = this.threadFactory(metricPrefix, metricRegistry);
        Executor executor = this.executor(metricPrefix, numThreads, threadFactory, metricRegistry);
        switch (this.configuration.getType()) {
            case EPOLL: {
                return this.epollEventLoopGroup(numThreads, executor);
            }
            case KQUEUE: {
                return this.kqueueEventLoopGroup(numThreads, executor);
            }
            case NIO: {
                return this.nioEventLoopGroup(numThreads, executor);
            }
        }
        throw new RuntimeException("Invalid or unknown netty transport type " + String.valueOf((Object)this.configuration.getType()));
    }

    private ThreadFactory threadFactory(String name, MetricRegistry metricRegistry) {
        String threadFactoryMetricName = MetricRegistry.name((String)name, (String[])new String[]{"thread-factory"});
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("netty-transport-%d").build();
        return new InstrumentedThreadFactory(threadFactory, metricRegistry, threadFactoryMetricName);
    }

    private Executor executor(String name, int numThreads, ThreadFactory threadFactory, MetricRegistry metricRegistry) {
        String executorMetricName = LocalMetricRegistry.name((String)name, (String[])new String[]{"executor-service"});
        ExecutorService cachedThreadPool = Executors.newFixedThreadPool(numThreads, threadFactory);
        return new InstrumentedExecutorService(cachedThreadPool, metricRegistry, executorMetricName);
    }

    private EventLoopGroup nioEventLoopGroup(int numThreads, Executor executor) {
        return new NioEventLoopGroup(numThreads, executor);
    }

    private EventLoopGroup epollEventLoopGroup(int numThreads, Executor executor) {
        return new EpollEventLoopGroup(numThreads, executor);
    }

    private EventLoopGroup kqueueEventLoopGroup(int numThreads, Executor executor) {
        return new KQueueEventLoopGroup(numThreads, executor);
    }
}

