/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters.dsvhttp;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class HTTPFileRetriever {
    private final AtomicReference<Map<String, String>> lastLastModified = new AtomicReference(Collections.emptyMap());
    private final OkHttpClient client;

    @Inject
    public HTTPFileRetriever(OkHttpClient httpClient) {
        this.client = httpClient.newBuilder().followRedirects(true).followSslRedirects(true).build();
    }

    public Optional<String> fetchFile(String url) throws IOException {
        return this.fetchFile(url, false);
    }

    public Optional<byte[]> fetchFileBytes(String url) throws IOException {
        return this.fetchFileBytes(url, false);
    }

    public boolean downloadFile(String url, Path toPath) throws IOException {
        return this.downloadFile(url, toPath, false);
    }

    public Optional<String> fetchFileIfNotModified(String url) throws IOException {
        return this.fetchFile(url, true);
    }

    public Optional<byte[]> fetchFileBytesIfNotModified(String url) throws IOException {
        return this.fetchFileBytes(url, true);
    }

    public boolean downloadFileIfNotModified(String url, Path toPath) throws IOException {
        return this.downloadFile(url, toPath, true);
    }

    private boolean downloadFile(String url, Path toPath, boolean addIfModifiedSinceHeader) throws IOException {
        try (Response response = this.doHttpGet(url, addIfModifiedSinceHeader);){
            if (null != response && null != response.body()) {
                Files.copy(response.body().byteStream(), toPath, StandardCopyOption.REPLACE_EXISTING);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private Optional<byte[]> fetchFileBytes(String url, boolean addIfModifiedSinceHeader) throws IOException {
        try (Response response = this.doHttpGet(url, addIfModifiedSinceHeader);){
            if (null != response && null != response.body()) {
                Optional<byte[]> optional = Optional.of(response.body().bytes());
                return optional;
            }
        }
        return Optional.empty();
    }

    private Optional<String> fetchFile(String url, boolean addIfModifiedSinceHeader) throws IOException {
        try (Response response = this.doHttpGet(url, addIfModifiedSinceHeader);){
            if (null != response && null != response.body()) {
                Optional<String> optional = Optional.of(response.body().string());
                return optional;
            }
        }
        return Optional.empty();
    }

    private Response doHttpGet(String url, boolean addIfModifiedSinceHeader) throws IOException {
        Call request;
        Response response;
        String lastModified;
        Request.Builder requestBuilder = new Request.Builder().get().url(url).header("User-Agent", "Graylog (server)");
        if (addIfModifiedSinceHeader && (lastModified = this.lastLastModified.get().get(url)) != null) {
            requestBuilder.header("If-Modified-Since", lastModified);
        }
        if ((response = (request = this.client.newCall(requestBuilder.build())).execute()).isSuccessful()) {
            String lastModifiedHeader = response.header("Last-Modified", DateTime.now((DateTimeZone)DateTimeZone.UTC).toString());
            HashMap<String, String> newLastModified = new HashMap<String, String>(this.lastLastModified.get());
            newLastModified.put(url, lastModifiedHeader);
            this.lastLastModified.set((Map<String, String>)ImmutableMap.copyOf(newLastModified));
            return response;
        }
        response.close();
        if (response.code() != 304) {
            throw new IOException("Request failed: " + response.message());
        }
        return null;
    }
}

