/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachine;
import org.graylog2.configuration.RunsWithDataNode;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.datanode.CurrentWriteIndices;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20240927120300_DataNodeMigrationIndexSet
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20240927120300_DataNodeMigrationIndexSet.class);
    private final Boolean runsWithDataNode;
    private final MigrationStateMachine migrationStateMachine;
    private final IndexSetRegistry indexSetRegistry;
    private final Indices indices;

    @Inject
    public V20240927120300_DataNodeMigrationIndexSet(@RunsWithDataNode Boolean runsWithDataNode, MigrationStateMachine migrationStateMachine, IndexSetRegistry indexSetRegistry, Indices indices) {
        this.runsWithDataNode = runsWithDataNode;
        this.migrationStateMachine = migrationStateMachine;
        this.indexSetRegistry = indexSetRegistry;
        this.indices = indices;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2024-09-27T12:03:00Z");
    }

    @Override
    public void upgrade() {
        if (!this.runsWithDataNode.booleanValue()) {
            return;
        }
        this.migrationStateMachine.getContext().getExtendedState("indexSetWriteIndices", CurrentWriteIndices.class).ifPresent(currentWriteIndices -> {
            currentWriteIndices.writeIndices().forEach((indexSetId, currentWriteIndex) -> this.indexSetRegistry.get((String)indexSetId).ifPresent(indexSet -> {
                try {
                    indexSet.getNewestIndex();
                }
                catch (NoTargetIndexException e) {
                    LOG.info("No existing index found for {}, creating last known index now", indexSetId);
                    this.indices.create((String)currentWriteIndex, (IndexSet)indexSet);
                    indexSet.setUp();
                }
            }));
            this.migrationStateMachine.getContext().removeExtendedState("indexSetWriteIndices");
            this.migrationStateMachine.saveContext();
        });
    }
}

