/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.graylog2.indexer.messages.ImmutableMessage;
import org.graylog2.indexer.messages.IndexingResults;
import org.graylog2.indexer.messages.MessageWithIndex;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.outputs.filter.DefaultFilteredMessage;
import org.graylog2.outputs.filter.FilteredMessage;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.outputs.FilteredMessageOutput;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ElasticSearchOutput
implements MessageOutput,
FilteredMessageOutput {
    public static final String FILTER_KEY = "indexer";
    private static final String WRITES_METRICNAME = MetricRegistry.name(ElasticSearchOutput.class, (String[])new String[]{"writes"});
    private static final String FAILURES_METRICNAME = MetricRegistry.name(ElasticSearchOutput.class, (String[])new String[]{"failures"});
    private static final String PROCESS_TIME_METRICNAME = MetricRegistry.name(ElasticSearchOutput.class, (String[])new String[]{"processTime"});
    private static final String NAME = "ElasticSearch Output";
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchOutput.class);
    private final Meter writes;
    private final Meter ignores;
    private final Meter failures;
    private final Timer processTime;
    private final Messages messages;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    @Inject
    public ElasticSearchOutput(MetricRegistry metricRegistry, Messages messages) {
        this.messages = messages;
        this.writes = metricRegistry.meter(WRITES_METRICNAME);
        this.failures = metricRegistry.meter(FAILURES_METRICNAME);
        this.processTime = metricRegistry.timer(PROCESS_TIME_METRICNAME);
        this.ignores = metricRegistry.meter(MetricRegistry.name(FilteredMessageOutput.class, (String[])new String[]{FILTER_KEY, "ignores"}));
        this.isRunning.set(true);
    }

    @Override
    public void writeFiltered(List<FilteredMessage> filteredMessages) throws Exception {
        List<FilteredMessage> messages = filteredMessages.stream().filter(message -> !message.destinations().get((Object)FILTER_KEY).isEmpty()).toList();
        this.ignores.mark((long)(filteredMessages.size() - messages.size()));
        this.writeMessageEntries(messages);
    }

    @Override
    public void write(Message message) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing message id to [{}]: <{}>", (Object)NAME, (Object)message.getId());
        }
        this.writeMessageEntries(List.of(DefaultFilteredMessage.forDestinationKeys(message, Set.of(FILTER_KEY))));
    }

    @Override
    public void write(List<Message> messageList) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing {} messages to [{}]", (Object)messageList.size(), (Object)NAME);
        }
        this.writeMessageEntries(messageList.stream().map(message -> DefaultFilteredMessage.forDestinationKeys(message, Set.of(FILTER_KEY))).collect(Collectors.toList()));
    }

    private void writeMessageEntries(List<FilteredMessage> messageList) {
        IndexingResults indexingResults;
        List<MessageWithIndex> messagesWithIndex = messageList.stream().flatMap(message -> message.destinations().get((Object)FILTER_KEY).stream().map(stream -> new MessageWithIndex(message.message(), stream.getIndexSet()))).toList();
        if (LOG.isTraceEnabled()) {
            String sortedIds = messagesWithIndex.stream().map(MessageWithIndex::message).map(ImmutableMessage::getId).sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
            LOG.trace("Writing message ids to [{}]: <{}>", (Object)NAME, (Object)sortedIds);
        }
        this.writes.mark((long)messageList.size());
        try (Timer.Context ignored = this.processTime.time();){
            indexingResults = this.messages.bulkIndex(messagesWithIndex);
        }
        this.failures.mark((long)indexingResults.errors().size());
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isRunning() {
        return this.isRunning.get();
    }

    public static class Descriptor
    extends MessageOutput.Descriptor {
        public Descriptor() {
            super("Elasticsearch Output", false, "", "Elasticsearch Output");
        }

        public Descriptor(String name, boolean exclusive, String linkToDocs, String humanName) {
            super(name, exclusive, linkToDocs, humanName);
        }
    }

    public static class Config
    extends MessageOutput.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            return new ConfigurationRequest();
        }
    }

    public static interface Factory
    extends MessageOutput.Factory<ElasticSearchOutput> {
        @Override
        public ElasticSearchOutput create(Stream var1, Configuration var2);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

