/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.Meter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Size;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.messages.ImmutableMessage;
import org.graylog2.indexer.messages.SerializationContext;
import org.graylog2.outputs.BatchSizeConfig;
import org.graylog2.outputs.filter.FilteredMessage;

public class IndexSetAwareMessageOutputBuffer {
    private final int maxBufferSizeCount;
    private final long maxBufferSizeBytes;
    private final ObjectMapper objectMapper;
    private volatile List<FilteredMessage> buffer;
    private volatile int bufferLength = 0;
    private volatile long bufferSizeBytes = 0L;
    private final AtomicLong lastFlushTime = new AtomicLong();

    @Inject
    public IndexSetAwareMessageOutputBuffer(@Named(value="output_batch_size") BatchSizeConfig maxBufferSize, ObjectMapper objectMapper) {
        this.maxBufferSizeCount = maxBufferSize.getAsCount().orElse(0);
        this.maxBufferSizeBytes = maxBufferSize.getAsBytes().map(Size::toBytes).orElse(0L);
        this.buffer = new ArrayList<FilteredMessage>(maxBufferSize.getAsCount().orElse(500));
        this.objectMapper = objectMapper;
    }

    public boolean shouldFlush(Duration flushInterval) {
        long lastFlush = this.lastFlushTime.get();
        return lastFlush == 0L || System.nanoTime() - lastFlush > flushInterval.toNanos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendAndFlush(FilteredMessage filteredMessage, Consumer<List<FilteredMessage>> flusher) {
        List<FilteredMessage> flushBatch = null;
        IndexSetAwareMessageOutputBuffer indexSetAwareMessageOutputBuffer = this;
        synchronized (indexSetAwareMessageOutputBuffer) {
            this.buffer.add(filteredMessage);
            this.bufferLength += Math.max(filteredMessage.message().getIndexSets().size(), 1);
            if (this.maxBufferSizeBytes != 0L) {
                this.bufferSizeBytes += IndexSetAwareMessageOutputBuffer.estimateOsBulkRequestSize(filteredMessage.message(), this.objectMapper);
            }
            if (this.maxBufferSizeBytes != 0L && this.bufferSizeBytes >= this.maxBufferSizeBytes || this.maxBufferSizeCount != 0 && this.bufferLength >= this.maxBufferSizeCount) {
                flushBatch = this.buffer;
                this.buffer = new ArrayList<FilteredMessage>(this.bufferLength);
                this.bufferLength = 0;
                this.bufferSizeBytes = 0L;
            }
        }
        if (flushBatch != null) {
            this.lastFlushTime.set(System.nanoTime());
            flusher.accept(flushBatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Consumer<List<FilteredMessage>> flusher) {
        List<FilteredMessage> flushBatch;
        IndexSetAwareMessageOutputBuffer indexSetAwareMessageOutputBuffer = this;
        synchronized (indexSetAwareMessageOutputBuffer) {
            flushBatch = this.buffer;
            this.buffer = new ArrayList<FilteredMessage>(this.bufferLength);
            this.bufferLength = 0;
            this.bufferSizeBytes = 0L;
        }
        if (flushBatch != null) {
            this.lastFlushTime.set(System.nanoTime());
            flusher.accept(flushBatch);
        }
    }

    @VisibleForTesting
    static long estimateOsBulkRequestSize(ImmutableMessage message, ObjectMapper objectMapper) {
        long msgSize;
        try {
            msgSize = message.serialize(SerializationContext.of(objectMapper, new Meter())).length + 1;
        }
        catch (IOException e) {
            msgSize = 0L;
        }
        long indexInstructionsSize = message.getIndexSets().stream().map(IndexSet::getWriteIndexAlias).mapToLong(index -> 32L + (long)((String)MoreObjects.firstNonNull((Object)index, (Object)"")).length() + 36L + 1L).sum();
        return indexInstructionsSize + msgSize * (long)Math.max(message.getIndexSets().size(), 1);
    }
}

