/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.outputs.MessageOutputConfigurationException;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.resources.streams.outputs.AvailableOutputSummary;

public class MessageOutputFactory {
    private final Map<String, MessageOutput.Factory<? extends MessageOutput>> availableOutputs;
    private final Map<String, MessageOutput.Factory2<? extends MessageOutput>> availableOutputs2;

    @Inject
    public MessageOutputFactory(Map<String, MessageOutput.Factory<? extends MessageOutput>> availableOutputs, Map<String, MessageOutput.Factory2<? extends MessageOutput>> availableOutputs2) {
        this.availableOutputs = availableOutputs;
        this.availableOutputs2 = availableOutputs2;
    }

    public MessageOutput fromStreamOutput(Output output, Stream stream, Configuration configuration) throws MessageOutputConfigurationException {
        Preconditions.checkNotNull((Object)output);
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)configuration);
        String outputType = output.getType();
        Preconditions.checkArgument((outputType != null ? 1 : 0) != 0);
        MessageOutput.Factory2<? extends MessageOutput> factory2 = this.availableOutputs2.get(outputType);
        MessageOutput.Factory<? extends MessageOutput> factory = this.availableOutputs.get(outputType);
        if (factory2 != null) {
            return factory2.create(output, stream, configuration);
        }
        if (factory != null) {
            return factory.create(stream, configuration);
        }
        throw new IllegalArgumentException("Output type is not supported: " + outputType);
    }

    public Map<String, AvailableOutputSummary> getAvailableOutputs() {
        AvailableOutputSummary availableOutputSummary;
        MessageOutput.Descriptor descriptor;
        Object messageOutputFactoryClass;
        HashMap<String, AvailableOutputSummary> result = new HashMap<String, AvailableOutputSummary>(this.availableOutputs.size());
        for (Map.Entry<String, MessageOutput.Factory<? extends MessageOutput>> entry : this.availableOutputs.entrySet()) {
            messageOutputFactoryClass = entry.getValue();
            descriptor = messageOutputFactoryClass.getDescriptor();
            availableOutputSummary = this.createOutputSummary(entry.getKey(), descriptor, messageOutputFactoryClass.getConfig());
            result.put(entry.getKey(), availableOutputSummary);
        }
        for (Map.Entry<String, Object> entry : this.availableOutputs2.entrySet()) {
            messageOutputFactoryClass = (MessageOutput.Factory2)entry.getValue();
            descriptor = messageOutputFactoryClass.getDescriptor();
            availableOutputSummary = this.createOutputSummary(entry.getKey(), descriptor, messageOutputFactoryClass.getConfig());
            result.put(entry.getKey(), availableOutputSummary);
        }
        return result;
    }

    private AvailableOutputSummary createOutputSummary(String outputType, MessageOutput.Descriptor descriptor, MessageOutput.Config config) {
        return AvailableOutputSummary.create(descriptor.getName(), outputType, descriptor.getHumanName(), descriptor.getLinkToDocs(), config.getRequestedConfiguration());
    }
}

