/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import jakarta.inject.Inject;
import java.util.Set;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.system.traffic.TrafficCounterCalculator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficCounterPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficCounterPeriodical.class);
    private final Set<TrafficCounterCalculator> trafficCounterCalculators;

    @Inject
    public TrafficCounterPeriodical(Set<TrafficCounterCalculator> trafficCounterCalculators) {
        this.trafficCounterCalculators = trafficCounterCalculators;
    }

    @Override
    public void doRun() {
        DateTime now = Tools.nowUTC();
        int secondOfMinute = now.getSecondOfMinute();
        if (secondOfMinute == 0) {
            this.trafficCounterCalculators.forEach(trafficCounterCalculator -> {
                DateTime previousMinute = now.minusMinutes(1);
                trafficCounterCalculator.calculate(previousMinute);
            });
        }
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean leaderOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

