/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.github.zafarkhaja.semver.Version;
import org.graylog2.shared.ServerVersion;

public enum DocsHelper {
    PAGE_SENDING_JSONPATH("getting_in_log_data/json_path_from_http_api_input.html"),
    PAGE_SENDING_IPFIXPATH("getting_in_log_data/ipfix_input.html"),
    PAGE_ES_CONFIGURATION("https://go2docs.graylog.org/current/setting_up_graylog/server.conf.html#OpenSearch"),
    PAGE_ES_VERSIONS("downloading_and_installing_graylog/installing_graylog.html#CompatibilityMatrix"),
    REPORTING_HELP("interacting_with_your_log_data/reporting.html");

    private static final String SERVER = "https://go2docs.graylog.org";
    private final String path;

    private DocsHelper(String path) {
        this.path = path;
    }

    public String toString() {
        return "https://go2docs.graylog.org/" + this.version() + "/" + this.path;
    }

    private String version() {
        Version version = ServerVersion.VERSION.getVersion();
        if (version.toString().contains("SNAPSHOT")) {
            return "current";
        }
        return version.getMajorVersion() + "-" + version.getMinorVersion();
    }

    public String toLink(String title) {
        return "<a href=\"" + String.valueOf((Object)this) + "\" target=\"_blank\">" + title + "</a>";
    }
}

