/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.graylog2.cluster.Node;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class RemoteInterfaceProvider {
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final Duration defaultProxyTimeout;

    @Inject
    public RemoteInterfaceProvider(ObjectMapper objectMapper, OkHttpClient okHttpClient, @Named(value="proxied_requests_default_call_timeout") com.github.joschi.jadconfig.util.Duration defaultProxyTimeout) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.defaultProxyTimeout = Duration.ofMillis(defaultProxyTimeout.toMilliseconds());
    }

    public <T> T get(Node node, String authorizationToken, Class<T> interfaceClass, Duration timeout) {
        OkHttpClient okHttpClient = this.okHttpClient.newBuilder().writeTimeout(timeout).readTimeout(timeout).callTimeout(timeout).connectTimeout(timeout).addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder builder = original.newBuilder().header("X-Requested-By", "Graylog Server");
            if (original.headers("Accept").isEmpty()) {
                builder.header("Accept", MediaType.JSON_UTF_8.toString());
            }
            if (authorizationToken != null) {
                builder.header("Authorization", authorizationToken).header("X-Graylog-No-Session-Extension", "true");
            }
            return chain.proceed(builder.build());
        }).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(node.getTransportAddress()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).client(okHttpClient).build();
        return (T)retrofit.create(interfaceClass);
    }

    public <T> T get(Node node, String authorizationToken, Class<T> interfaceClass) {
        return this.get(node, authorizationToken, interfaceClass, this.defaultProxyTimeout);
    }

    public <T> T get(Node node, Class<T> interfaceClass) {
        return this.get(node, null, interfaceClass);
    }
}

