/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Objects;
import org.graylog2.plugin.Version;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.rest.models.HelloWorldResponse;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="Hello World", description="A friendly hello world message")
@Path(value="/")
public class HelloWorldResource
extends RestResource {
    private final NodeId nodeId;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public HelloWorldResource(NodeId nodeId, ClusterConfigService clusterConfigService) {
        this.nodeId = Objects.requireNonNull(nodeId);
        this.clusterConfigService = Objects.requireNonNull(clusterConfigService);
    }

    @GET
    @Timed
    @ApiOperation(value="A few details about the Graylog node.")
    @Produces(value={"application/json"})
    public HelloWorldResponse helloWorld() {
        ClusterId clusterId = this.clusterConfigService.getOrDefault(ClusterId.class, ClusterId.create("UNKNOWN"));
        return HelloWorldResponse.create(clusterId.clusterId(), this.nodeId.getNodeId(), Version.CURRENT_CLASSPATH.toString(), "Manage your logs in the dark and have lasers going and make it look like you're from space!");
    }
}

