/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Objects;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.IndexSetValidator;
import org.graylog2.indexer.indexset.template.IndexSetDefaultTemplateService;
import org.graylog2.indexer.indexset.template.IndexSetTemplate;
import org.graylog2.indexer.indexset.template.IndexSetTemplateConfig;
import org.graylog2.indexer.indexset.template.IndexSetTemplateRequest;
import org.graylog2.indexer.indexset.template.IndexSetTemplateService;
import org.graylog2.indexer.indexset.template.requirement.IndexSetTemplateRequirement;
import org.graylog2.indexer.indexset.template.requirement.IndexSetTemplateRequirementsChecker;
import org.graylog2.indexer.indexset.template.rest.IndexSetTemplateResponse;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.utilities.StringUtils;

@RequiresAuthentication
@Api(value="System/IndexSets/Templates", description="Index-set Configuration Template Management", tags={"cloud"})
@Path(value="/system/indices/index_sets/templates")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class IndexSetTemplateResource
extends RestResource {
    private final IndexSetValidator indexSetValidator;
    private final Validator validator;
    private final IndexSetTemplateService templateService;
    private final IndexSetDefaultTemplateService indexSetDefaultTemplateService;
    private final IndexSetTemplateRequirementsChecker indexSetTemplateRequirementsChecker;

    @Inject
    public IndexSetTemplateResource(IndexSetValidator indexSetValidator, Validator validator, IndexSetTemplateService templateService, IndexSetDefaultTemplateService indexSetDefaultTemplateService, IndexSetTemplateRequirementsChecker indexSetTemplateRequirementsChecker) {
        this.indexSetValidator = indexSetValidator;
        this.validator = validator;
        this.templateService = templateService;
        this.indexSetDefaultTemplateService = indexSetDefaultTemplateService;
        this.indexSetTemplateRequirementsChecker = indexSetTemplateRequirementsChecker;
    }

    @GET
    @Path(value="/{template_id}")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets template by id")
    public IndexSetTemplateResponse retrieveById(@ApiParam(name="template_id") @PathParam(value="template_id") String templateId) {
        this.checkPermission("indexset_templates:read", templateId);
        return this.getIndexSetTemplate(templateId);
    }

    @GET
    @Path(value="/default_config")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets default template")
    public IndexSetTemplateConfig getDefaultConfig() {
        return this.indexSetDefaultTemplateService.getOrCreateDefaultConfig();
    }

    @GET
    @Path(value="/paginated")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets template by id")
    public PageListResponse<IndexSetTemplateResponse> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="filters") @QueryParam(value="filters") List<String> filters, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="name") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        this.checkPermission("indexset_templates:read");
        return this.toPaginatedResponse(this.templateService.getPaginated(query, filters, page, perPage, sort, order));
    }

    @GET
    @Path(value="/built-in")
    @Timed
    @ApiOperation(value="Gets built-in templates")
    public List<IndexSetTemplateResponse> builtIns(@ApiParam(name="warm_tier_enabled") @QueryParam(value="warm_tier_enabled") boolean warmTierEnabled) {
        this.checkPermission("indexset_templates:read");
        return this.toResponse(this.templateService.getBuiltIns(warmTierEnabled));
    }

    @POST
    @Timed
    @AuditEvent(type="server:index_set_template:create")
    @ApiOperation(value="Creates a new editable template")
    public IndexSetTemplateResponse create(@ApiParam(name="request") IndexSetTemplateRequest templateData) {
        this.checkPermission("indexset_templates:create");
        this.validateConfig(templateData.indexSetConfig());
        return this.toResponse(this.templateService.save(new IndexSetTemplate(templateData)));
    }

    @PUT
    @Path(value="{id}")
    @Timed
    @AuditEvent(type="server:index_set_template:update")
    @ApiOperation(value="Updates existing template")
    public void update(@ApiParam(name="id", required=true) @PathParam(value="id") String id, @ApiParam(name="request") @NotNull IndexSetTemplateRequest template) throws IllegalAccessException {
        this.checkPermission("indexset_templates:edit", id);
        this.checkReadOnly(this.getIndexSetTemplate(id));
        this.validateConfig(template.indexSetConfig());
        boolean updated = this.templateService.update(id, new IndexSetTemplate(template));
        if (!updated) {
            throw new NotFoundException(StringUtils.f("Template %s <%s> does not exist", id, template.title()));
        }
    }

    @DELETE
    @Path(value="/{template_id}")
    @Timed
    @AuditEvent(type="server:index_set_template:delete")
    @ApiOperation(value="Removes a template")
    public void delete(@ApiParam(name="template_id") @PathParam(value="template_id") String templateId) throws IllegalAccessException {
        this.checkPermission("indexset_templates:delete", templateId);
        IndexSetTemplateResponse template = this.getIndexSetTemplate(templateId);
        this.checkReadOnly(template);
        this.checkIsDefault(template);
        this.templateService.delete(templateId);
    }

    private void validateConfig(IndexSetTemplateConfig config) {
        IndexSetValidator.Violation violation = this.indexSetValidator.checkDataTieringNotNull(config.useLegacyRotation(), config.dataTieringConfig());
        if (violation != null) {
            throw new BadRequestException(violation.message());
        }
        this.validator.validate((Object)config, new Class[0]).forEach(v -> {
            throw new BadRequestException(StringUtils.f("Invalid value for field [%s]: %s", v.getPropertyPath().toString(), v.getMessage()));
        });
        violation = this.indexSetValidator.validateRefreshInterval(config.fieldTypeRefreshInterval());
        if (violation != null) {
            throw new BadRequestException(violation.message());
        }
        violation = config.useLegacyRotation() != false ? this.indexSetValidator.validateStrategyFields(config) : this.indexSetValidator.validateDataTieringConfig(config.dataTieringConfig());
        if (violation != null) {
            throw new BadRequestException(violation.message());
        }
    }

    private IndexSetTemplateResponse getIndexSetTemplate(String templateId) {
        return this.templateService.get(templateId).map(this::toResponse).orElseThrow(() -> new NotFoundException(StringUtils.f("No template with id %s", templateId)));
    }

    @Nonnull
    private IndexSetTemplateResponse toResponse(IndexSetTemplate indexSetTemplate) {
        return this.toResponse(indexSetTemplate, this.indexSetDefaultTemplateService.getDefaultIndexSetTemplateId());
    }

    private void checkIsDefault(IndexSetTemplateResponse template) throws IllegalAccessException {
        if (template.isDefault()) {
            throw new IllegalAccessException(StringUtils.f("Template %s <%s> is set as default and cannot be deleted", template.title(), template.id()));
        }
    }

    private void checkReadOnly(IndexSetTemplateResponse template) throws IllegalAccessException {
        if (template.isBuiltIn()) {
            throw new IllegalAccessException(StringUtils.f("Template %s <%s> is read-only and cannot be modified or deleted", template.title(), template.id()));
        }
    }

    private PageListResponse<IndexSetTemplateResponse> toPaginatedResponse(PageListResponse<IndexSetTemplate> pageListResponse) {
        return PageListResponse.create(pageListResponse.query(), pageListResponse.paginationInfo(), pageListResponse.total(), pageListResponse.sort(), pageListResponse.order(), this.toResponse(pageListResponse.elements()), pageListResponse.attributes(), pageListResponse.defaults());
    }

    private List<IndexSetTemplateResponse> toResponse(List<IndexSetTemplate> templates) {
        String defaultIndexSetTemplateId = this.indexSetDefaultTemplateService.getDefaultIndexSetTemplateId();
        return templates.stream().map(indexSetTemplate -> this.toResponse((IndexSetTemplate)indexSetTemplate, defaultIndexSetTemplateId)).toList();
    }

    private IndexSetTemplateResponse toResponse(IndexSetTemplate indexSetTemplate, String defaultTemplateId) {
        IndexSetTemplateRequirement.Result result = this.indexSetTemplateRequirementsChecker.check(indexSetTemplate);
        return new IndexSetTemplateResponse(indexSetTemplate.id(), indexSetTemplate.title(), indexSetTemplate.description(), indexSetTemplate.isBuiltIn(), Objects.equals(defaultTemplateId, indexSetTemplate.id()), result.fulfilled(), result.reason(), indexSetTemplate.indexSetConfig());
    }
}

