/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.rest.models.system.indexer.responses.ClusterHealth;
import org.graylog2.rest.models.system.indexer.responses.ClusterInfo;
import org.graylog2.rest.models.system.indexer.responses.ClusterName;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.storage.providers.ElasticsearchVersionProvider;

@RequiresAuthentication
@Api(value="Indexer/Cluster", description="Indexer cluster information")
@Path(value="/system/indexer/cluster")
public class IndexerClusterResource
extends RestResource {
    private final Cluster cluster;
    private final ElasticsearchVersionProvider elasticsearchVersionProvider;

    @Inject
    public IndexerClusterResource(Cluster cluster, ElasticsearchVersionProvider elasticsearchVersionProvider) {
        this.cluster = cluster;
        this.elasticsearchVersionProvider = elasticsearchVersionProvider;
    }

    @GET
    @Timed
    @Path(value="/name")
    @RequiresPermissions(value={"indexercluster:read"})
    @ApiOperation(value="Get the cluster name")
    @Produces(value={"application/json"})
    public ClusterName clusterName() {
        String clusterName = this.cluster.clusterName().orElseThrow(() -> new InternalServerErrorException("Couldn't read Elasticsearch cluster health"));
        return ClusterName.create(clusterName);
    }

    @GET
    @Timed
    @Path(value="/info")
    @RequiresPermissions(value={"indexercluster:read"})
    @ApiOperation(value="Get cluster name and distribution")
    @Produces(value={"application/json"})
    public ClusterInfo clusterInfo() {
        String clusterName = this.cluster.clusterName().orElseThrow(() -> new InternalServerErrorException("Couldn't read indexer cluster info"));
        return new ClusterInfo(clusterName, this.elasticsearchVersionProvider.get().distribution().toString());
    }

    @GET
    @Timed
    @Path(value="/health")
    @ApiOperation(value="Get cluster and shard health overview")
    @RequiresPermissions(value={"indexercluster:read"})
    @Produces(value={"application/json"})
    public ClusterHealth clusterHealth() {
        return this.cluster.clusterHealthStats().orElseThrow(() -> new InternalServerErrorException("Couldn't read Elasticsearch cluster health"));
    }
}

