/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruststoreUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TruststoreUtils.class);

    public static Optional<KeyStore> loadJvmTruststore() {
        return TruststoreUtils.jvmTruststoreLocation().map(location -> {
            String password = TruststoreUtils.jvmTruststorePassword();
            String type = TruststoreUtils.jvmTruststoreType();
            LOG.info("Detected existing JVM truststore: " + String.valueOf(location.toAbsolutePath()) + " of type " + type);
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                try (InputStream is = Files.newInputStream(location, new OpenOption[0]);){
                    trustStore.load(is, password.toCharArray());
                }
                return trustStore;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static String jvmTruststoreType() {
        return Optional.ofNullable(System.getProperty("javax.net.ssl.trustStoreType")).filter(type -> !type.isEmpty()).orElseGet(KeyStore::getDefaultType);
    }

    private static String jvmTruststorePassword() {
        return Optional.ofNullable(System.getProperty("javax.net.ssl.trustStorePassword")).filter(p -> !p.isEmpty()).orElse("changeit");
    }

    private static Optional<Path> jvmTruststoreLocation() {
        String javaHome = System.getProperty("java.home");
        return Stream.of(TruststoreUtils.truststoreSystemProperty(), TruststoreUtils.libSecurityFile(javaHome, "jssecacerts"), TruststoreUtils.libSecurityFile(javaHome, "cacerts")).filter(Optional::isPresent).map(Optional::get).filter(TruststoreUtils::isReadableFile).findFirst();
    }

    @Nonnull
    private static Optional<Path> libSecurityFile(String javaHome, String filename) {
        return Optional.ofNullable(javaHome).map(home -> Paths.get(home, "lib", "security", filename));
    }

    @Nonnull
    private static Optional<Path> truststoreSystemProperty() {
        return Optional.ofNullable(System.getProperty("javax.net.ssl.trustStore")).filter(p -> !p.isEmpty()).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    private static boolean isReadableFile(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path);
    }
}

