/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.graylog.security.authservice.AuthServiceAuthenticator;
import org.graylog.security.authservice.AuthServiceException;
import org.graylog.security.authservice.AuthServiceResult;
import org.graylog.security.authservice.AuthServiceToken;
import org.graylog2.shared.security.AuthenticationServiceUnavailableException;
import org.graylog2.shared.security.TypedBearerToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenRealm
extends AuthenticatingRealm {
    private static final Logger log = LoggerFactory.getLogger(BearerTokenRealm.class);
    public static final String NAME = "bearer-token";
    private final AuthServiceAuthenticator authenticator;

    @Inject
    public BearerTokenRealm(AuthServiceAuthenticator authenticator) {
        this.authenticator = authenticator;
        this.setAuthenticationTokenClass(TypedBearerToken.class);
        this.setCachingEnabled(false);
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authToken) throws AuthenticationException {
        if (authToken instanceof TypedBearerToken) {
            return this.doGetAuthenticationInfo((TypedBearerToken)authToken);
        }
        throw new UnsupportedTokenException("Unsupported authentication token type: " + String.valueOf(authToken.getClass()));
    }

    private AuthenticationInfo doGetAuthenticationInfo(TypedBearerToken token) throws AuthenticationException {
        log.debug("Attempting authentication for bearer token of type <{}>.", (Object)token.getType());
        try {
            AuthServiceResult result = this.authenticator.authenticate(AuthServiceToken.builder().token(token.getToken()).type(token.getType()).build());
            if (result.isSuccess()) {
                log.debug("Successfully authenticated username <{}> for user profile <{}> with backend <{}/{}/{}>", new Object[]{result.username(), result.userProfileId(), result.backendTitle(), result.backendType(), result.backendId()});
                return this.toAuthenticationInfo(result);
            }
            log.warn("Failed to authenticate username <{}> with backend <{}/{}/{}>", new Object[]{result.username(), result.backendTitle(), result.backendType(), result.backendId()});
            return null;
        }
        catch (AuthServiceException e) {
            throw new AuthenticationServiceUnavailableException(e);
        }
        catch (Exception e) {
            log.error("Unhandled authentication error", (Throwable)e);
            return null;
        }
    }

    private AuthenticationInfo toAuthenticationInfo(AuthServiceResult result) {
        String realmName = "bearer-token/" + result.backendType();
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Collection)ImmutableList.of((Object)result.userProfileId(), result.sessionAttributes()), realmName);
        return new SimpleAccount((Object)principals, null, realmName);
    }
}

