/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.exceptionmappers;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.MoreObjects;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.graylog2.plugin.rest.RequestError;

@Provider
public class JsonProcessingExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    public Response toResponse(JsonProcessingException e) {
        String message = (String)MoreObjects.firstNonNull((Object)e.getOriginalMessage(), (Object)"Couldn't process JSON input");
        JsonLocation location = e.getLocation();
        RequestError apiError = RequestError.create(message, location.getLineNr(), location.getColumnNr(), "", null);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)apiError).build();
    }
}

