/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.csp;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSPResources {
    private static final Logger LOG = LoggerFactory.getLogger(CSPResources.class);
    private static final String DEFAULT_FILE = "/org/graylog2/security/csp.config";
    private Table<String, String, Set<String>> cspTable;

    public CSPResources() {
        this(DEFAULT_FILE);
    }

    public CSPResources(String resourceName) {
        try {
            this.cspTable = this.loadProperties(resourceName);
        }
        catch (Exception e) {
            LOG.warn("Could not load config resource {}: {}", (Object)resourceName, (Object)e.getMessage());
            this.cspTable = HashBasedTable.create();
        }
    }

    public String cspString(String group) {
        return this.cspTable.row((Object)group).keySet().stream().sorted().map(key -> key + " " + ((Set)this.cspTable.get((Object)group, key)).stream().sorted().collect(Collectors.joining(" "))).collect(Collectors.joining(";"));
    }

    public void updateAll(String directive, String value) {
        HashSet<String> valueSet = new HashSet<String>(Arrays.asList(value.split(" ")));
        this.cspTable.rowKeySet().forEach(group -> {
            if (this.cspTable.get(group, (Object)directive) == null) {
                this.cspTable.put(group, (Object)directive, (Object)valueSet);
            } else {
                ((Set)this.cspTable.get(group, (Object)directive)).addAll(valueSet);
            }
        });
    }

    private Table<String, String, Set<String>> loadProperties(String path) throws IOException {
        InputStream inputStream = CSPResources.class.getResourceAsStream(path);
        Properties properties = new Properties();
        properties.load(inputStream);
        HashBasedTable resources = HashBasedTable.create();
        for (String propertyName : properties.stringPropertyNames()) {
            String[] substrings = propertyName.split("[.]");
            if (substrings.length != 2) {
                LOG.warn("Skipping malformed property {}: expecting format <group>.<key>", (Object)propertyName);
                continue;
            }
            String[] valueArray = properties.getProperty(propertyName).split(" ");
            resources.put((Object)substrings[0], (Object)substrings[1], new HashSet<String>(Arrays.asList(valueArray)));
        }
        return resources;
    }
}

