/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.system.stats.fs;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.Configuration;
import org.graylog2.plugin.KafkaJournalConfiguration;
import org.graylog2.shared.system.stats.OshiService;
import org.graylog2.shared.system.stats.fs.FsProbe;
import org.graylog2.shared.system.stats.fs.FsStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HWPartition;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.common.AbstractHWDiskStore;
import oshi.software.common.AbstractOSFileStore;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.tuples.Pair;

public class OshiFsProbe
implements FsProbe {
    private static final Logger LOG = LoggerFactory.getLogger(OshiFsProbe.class);
    private final OshiService service;
    private final Set<Path> locations;
    private final Map<Path, Pair<OSFileStore, HWDiskStore>> oshiFileSystems = new HashMap<Path, Pair<OSFileStore, HWDiskStore>>();

    @Inject
    public OshiFsProbe(OshiService service, Configuration configuration, KafkaJournalConfiguration kafkaJournalConfiguration) {
        this.service = service;
        this.locations = ImmutableSet.of((Object)configuration.getBinDir(), (Object)configuration.getDataDir(), (Object)configuration.getPluginDir(), (Object)kafkaJournalConfiguration.getMessageJournalDir());
        this.init();
    }

    private void init() {
        OperatingSystem os = this.service.getOs();
        FileSystem fileSystem = os.getFileSystem();
        HardwareAbstractionLayer hardware = this.service.getHal();
        for (Path location : this.locations) {
            Path path = location.toAbsolutePath();
            this.oshiFileSystems.put(path, (Pair<OSFileStore, HWDiskStore>)fileSystem.getFileStores().stream().filter(fs -> path.startsWith(fs.getMount())).max(Comparator.comparingInt(p -> Paths.get(p.getMount(), new String[0]).getNameCount())).map(fs -> {
                Optional<HWDiskStore> diskStore = hardware.getDiskStores().stream().filter(ds -> ds.getName().equals(StringUtils.defaultIfEmpty((CharSequence)fs.getLogicalVolume(), (CharSequence)fs.getVolume()))).findFirst();
                if (diskStore.isPresent()) {
                    return new Pair(fs, (Object)diskStore.get());
                }
                diskStore = hardware.getDiskStores().stream().filter(ds -> ds.getPartitions().stream().anyMatch(part -> path.startsWith(part.getMountPoint()))).max(Comparator.comparingInt(ds -> ds.getPartitions().stream().filter(part -> path.startsWith(part.getMountPoint())).mapToInt(part -> Paths.get(part.getMountPoint(), new String[0]).getNameCount()).max().orElse(0)));
                if (diskStore.isPresent()) {
                    return new Pair(fs, (Object)diskStore.get());
                }
                return new Pair(fs, (Object)this.generateDummyDiskStore());
            }).orElse(new Pair((Object)this.generateDummyFileStore(), (Object)this.generateDummyDiskStore())));
        }
    }

    @Override
    public FsStats fsStats() {
        Map<String, FsStats.Filesystem> fsmap = this.oshiFileSystems.entrySet().stream().peek(it -> {
            ((OSFileStore)((Pair)it.getValue()).getA()).updateAttributes();
            ((HWDiskStore)((Pair)it.getValue()).getB()).updateAttributes();
        }).collect(Collectors.toMap(it -> ((Path)it.getKey()).toString(), it -> {
            HWDiskStore diskStore = (HWDiskStore)((Pair)it.getValue()).getB();
            OSFileStore fileStore = (OSFileStore)((Pair)it.getValue()).getA();
            return FsStats.Filesystem.create(((Path)it.getKey()).toString(), fileStore.getMount(), Optional.ofNullable(fileStore.getLogicalVolume()).orElse(fileStore.getVolume()), fileStore.getDescription(), fileStore.getType(), fileStore.getTotalSpace(), fileStore.getUsableSpace(), fileStore.getUsableSpace(), fileStore.getTotalSpace() - fileStore.getUsableSpace(), this.safePercentage(fileStore.getTotalSpace() - fileStore.getUsableSpace(), fileStore.getTotalSpace(), 0), fileStore.getTotalInodes(), fileStore.getFreeInodes(), fileStore.getTotalInodes() - fileStore.getFreeInodes(), this.safePercentage(fileStore.getTotalInodes() - fileStore.getFreeInodes(), fileStore.getTotalInodes(), 0), diskStore.getReads(), diskStore.getWrites(), diskStore.getReadBytes(), diskStore.getWriteBytes(), diskStore.getCurrentQueueLength(), diskStore.getTimeStamp());
        }));
        return FsStats.create(fsmap);
    }

    private short safePercentage(long nominator, long denominator, int override) {
        return denominator == 0L ? (short)override : (short)(nominator * 100L / denominator);
    }

    private HWDiskStore generateDummyDiskStore() {
        return new AbstractHWDiskStore("missing", "missing", "missing", 0L){

            public long getReads() {
                return 0L;
            }

            public long getReadBytes() {
                return 0L;
            }

            public long getWrites() {
                return 0L;
            }

            public long getWriteBytes() {
                return 0L;
            }

            public long getCurrentQueueLength() {
                return 0L;
            }

            public long getTransferTime() {
                return 0L;
            }

            public List<HWPartition> getPartitions() {
                return null;
            }

            public long getTimeStamp() {
                return 0L;
            }

            public boolean updateAttributes() {
                return false;
            }
        };
    }

    private OSFileStore generateDummyFileStore() {
        return new AbstractOSFileStore(){

            public String getLogicalVolume() {
                return "missing";
            }

            public String getDescription() {
                return "missing";
            }

            public String getType() {
                return "dummy";
            }

            public long getFreeSpace() {
                return 0L;
            }

            public long getUsableSpace() {
                return 0L;
            }

            public long getTotalSpace() {
                return 1L;
            }

            public long getFreeInodes() {
                return 0L;
            }

            public long getTotalInodes() {
                return 1L;
            }

            public boolean updateAttributes() {
                return false;
            }
        };
    }
}

